#include "C12832.h"
#include "LM75B.h"
#include <string> 
#include "mbed.h"

DigitalOut led_red (LED_RED);
DigitalOut led_green (LED_GREEN);
DigitalOut led_blue (LED_BLUE);

DigitalOut xr_led (D5);
DigitalOut xg_led (D9);
DigitalOut xb_led (PTC12);

Ticker tempSender;

int sw2_down, sw2_up, sw3_down, sw3_up, temp_flag;

C12832 lcd(D11, D13, D12, D7, D10);
LM75B lm_temp (D14, D15);
InterruptIn sw2_int (PTC6);             /* interrupts for the two on-board switches */
InterruptIn sw3_int (PTA4);

Serial pc(USBTX, USBRX);

void parse(string buf) {
    if (buf.find("ldg")==0) {
        led_green = 1-strtod(buf.substr(3).c_str(), NULL);
    }
    else if (buf.find("ldb")==0) {
        led_blue = 1-strtod(buf.substr(3).c_str(), NULL);
    }
    else if (buf.find("ldr")==0) {
        led_red = 1-strtod(buf.substr(3).c_str(), NULL);
    }
    if (buf.find("xdg")==0) {
        xg_led = 1-strtod(buf.substr(3).c_str(), NULL);
    }
    else if (buf.find("xdb")==0) {
        xb_led = 1-strtod(buf.substr(3).c_str(), NULL);
    }
    else if (buf.find("xdr")==0) {
        xr_led = 1-strtod(buf.substr(3).c_str(), NULL);
    }
    else if (buf.find("lcdclr")==0) {
        lcd.cls();
    }
    else if (buf.find("lcdloc")==0) {
        string coord = buf.substr(6);
        string x = buf.substr(0,buf.find(","));
        string y = buf.substr(buf.find(","));
        lcd.locate(atoi(x.c_str()),atoi(y.c_str()));    
    }
    else if(buf.find("lcdprn")==0) {
        lcd.printf(buf.substr(6).c_str());
    }
    else if(buf.find("temp")==0) {
        pc.printf("%f", lm_temp.read());
        pc.printf(";");
    }
}

void sendTemp(void)
{
    temp_flag = 1;
}

void sw2Down (void)
{
    sw2_down = 1;
}
 
 
void sw2Up (void)
{
    sw2_up = 1;
}

void sw3Down (void)
{
    sw3_down = 1;
}
 
 
void sw3Up (void)
{
    sw3_up = 1;
}

int main() {
    xb_led = 0;
    xr_led = 0;
    xg_led = 0;
    led_red=0;
    led_green=0;
    led_blue=0;
    
    sw2_int.mode (PullUp);
    
    sw2_int.fall(&sw2Down);
    sw2_int.rise(&sw2Up);
    
    sw3_int.mode (PullUp);
    
    sw3_int.fall(&sw3Down);
    sw3_int.rise(&sw3Up);
    
    tempSender.attach(&sendTemp, 2.0);
    
    pc.baud(115200);
    pc.printf("%f", lm_temp.read());
    pc.printf(";");
    string buf;
    while (true) {
        if(sw2_down) {
            pc.printf("2d;");
            sw2_down = 0;
        }
        if(sw2_up) {
            pc.printf("2u;");
            sw2_up = 0;
        }
        if(sw3_down) {
            pc.printf("3d;");
            sw3_down = 0;
        }
        if(sw3_up) {
            pc.printf("3u;");
            sw3_up = 0;
        }
        if(pc.readable()) {
            char x = pc.getc();
            if(x==';') {
                parse(buf);
                buf = "";
            }
            else {
                buf += x;
            }
        }
        if(temp_flag) {
            temp_flag=0;
            pc.printf("%f", lm_temp.read());
            pc.printf(";");
        }
    }
}

