#include "mbed.h"
#include "LM75B.h"     /* On sheild Temp sensor */
#include "MMA7660.h"   /* On sheild Accelerometer */
#include "C12832.h"    /* On sheild LCD */

Serial host (USBTX, USBRX);
LM75B temp  (D14, D15);
C12832 lcd  (D11, D13, D12, D7, D10);
MMA7660 MMA (D14, D15);
PwmOut speaker(D6);
InterruptIn sw2_int (PTC6);
static volatile int sw2_trig;


float tp, x, y, z, i;
int mode = 0;

/* the fall interrupt for button2 */
void sw2_interrupt (void)
{
    sw2_trig = 1;

}

/* The rise interrupt for button2 */
void sw2_interruptup (void)
{
    sw2_trig = 0;
    speaker = 0;
}

int main ()
{
    host.baud(38400);   /* Sets the baudrate which is the bits per second */
    sw2_trig = 0;


    sw2_int.rise (&sw2_interruptup);
    sw2_int.fall (&sw2_interrupt);
    for(;;) {

        /* Displays the Temperature  */
        tp = temp.read ();
        lcd.cls();
        lcd.locate (0, 1);
        lcd.printf ("Temp: %.3f C", tp);
        host.printf ("%.3f \r", tp );
        wait(0.5);


        // if temperature rises above certain point then play sound

        if(tp > 40) {
            speaker.period(1.0/500.0);
            speaker=0.5;

        }
        // If temperature falls below certain point then play sounds
        else if ( tp < 15) {
            speaker.period(1.0/500.0);
            speaker=0.5;

        }
        /* Displays the Accelerometer  */
        x = MMA.x();
        y = MMA.y();
        z = MMA.z();

        // host.printf("Accel: X: %4f Y: %4f Z: %4f\r\n ", x,y,z);
        wait(0.5);



        /* Checks to make sure the acceleromterter is moving still */

        if (x -1 < x < x+1 && y -1 < y < y+1 && z -1 < z < z+1) {
            i++;
        }
        if (i == 10) {
            speaker.period(1.0/500.0);
            speaker=0.5;
        }
        if (sw2_trig) {
            mode++;
            sw2_trig = 0;
        }
        /* puts the device to sleep */
        if (mode == 1) {
            lcd.cls();
            lcd.locate(0,1);
            lcd.printf("Now going into sleep mode");

            sleep();


        }

        /* wakes the device up */
        if (mode >= 2) {
            mode = 0;

        }


    }



}



