#include "mbed.h"
#include "LM75B.h"     /* On sheild Temp sensor */
#include "C12832.h"    /* On sheild LCD */
#include "FXOS8700Q.h"

PwmOut speaker (D6);
Serial host    (USBTX, USBRX);
LM75B temp     (D14, D15);
C12832 lcd     (D11, D13, D12, D7, D10);
Serial xbee    (D1, D0);
DigitalOut green_led_shield (PTA2);     /**/
DigitalOut red_led_shield (PTC4);       /* Shield LEDs */
DigitalOut blue_led_shield (PTA0);      /**/
I2C i2c(PTE25, PTE24);
FXOS8700QMagnetometer mag(i2c, FXOS8700CQ_SLAVE_ADDR1);

//Global variables
char input = '0';
char alert = 'A'; // degree
char warn  = 'W'; // temp 
char history = '0';
float x,y,z,tp, degree;

/* Makes the LED red */
void makeLEDRed (void)
{
    green_led_shield = 0;
    red_led_shield = 255;
    blue_led_shield = 0;
}

/* Makes the LED green */
void makeLEDGreen (void)
{
    green_led_shield = 255;
    red_led_shield = 0;
    blue_led_shield = 0;
}

int main()
{
    host.baud(38400);
    makeLEDGreen();
    float anti = abs(degree); 
    mag.enable();
    for(;;)
    {
        //Gather the data from the magnetometer 
        motion_data_counts_t mag_raw;
        mag.getAxis(mag_raw);               
        float magx; 
        float magy;   
        float degree = abs(atan2(magx,magy)*180*7/22);        
        mag.getX(magx);
        mag.getY(magy);
        //Print the data onto the LCD 
        lcd.cls();
        lcd.locate(1,1);
        lcd.printf("Magnetometer Degree: %.3f", degree);
        lcd.locate(1,11);
        tp = temp.read();
        lcd.printf("Temperature: %.3f C", tp);
        host.printf("%2.1f%3.0f%c\r\n", tp,degree,input);
        xbee.printf("%2.1f%3.0f%c", tp,degree,input);
        wait_ms(500);
        input = '0';
    
        
        // If the door moves, Send alert 
        if (abs(anti-degree) > 160 )
        {
           makeLEDRed(); 
           speaker.period(1/500);
           speaker=0.5;
         
           input = alert;
            
        }
        
        // If the temp goes too high or too low, send warning
        if (tp < 0 || tp > 45)
        {  
            makeLEDRed();
            speaker.period(1/500);
            speaker=0.5;
            input = warn;
        }
        
        //Receiving char response 
        if(xbee.readable())
        {
            input = xbee.getc();
            switch(input)
            {
                case 'y':
                makeLEDGreen();
                speaker=0;
                break;
            
                case 's':
                speaker=0;
                break;
            }
        }
    }
}