#include "PN532_I2C.h"
#include "PN532.h"
#include <inttypes.h>
#include "mbed.h"


DigitalOut ledBrd (LED1);   // arducleo onboard led
 
DigitalOut ledNFC (LED2);     // status led
 
DigitalOut rstNFC (D4);     // pn532 chip reset control
  
Serial pc(USBTX, USBRX);
 
 
// ----------------------------------------- I2C
I2C pn532_i2c (I2C_SDA, I2C_SCL);
PN532_I2C pn532_if (pn532_i2c);
 
int acceptedCard = 1232695128;
 
PN532 nfc(pn532_if);
 
/*==============================================================================
 * \brief reset the pn532 chip
 */
void reset_chip (void)
{
    rstNFC = 0;
    wait_ms (100);
    rstNFC = 1;
}
 
 
/*==============================================================================
 * \brief init the peripheral
 */
void setup(void)
{
    ledBrd = 0;
    ledNFC = 0;
    reset_chip ();
 
    uint32_t versiondata = 0;
    pc.baud(115200);
    pc.printf ("Hello!\n");
 
    while (1) {
        nfc.begin();
        nfc.SAMConfig();
        versiondata = nfc.getFirmwareVersion();
        if (! versiondata) {
            pc.printf("Didn't find PN53x board\n\n");
            wait_ms(500);
        } else {
            break;
        }
    }
 
    // Got ok data, print it out!
    pc.printf ("Found chip PN5%02X , Firmware ver. %d.%d\n",
               (versiondata>>24) & 0xFF,
               (versiondata>>16) & 0xFF,
               (versiondata>>8) & 0xFF);
 
    // Set the max number of retry attempts to read from a card
    // This prevents us from waiting forever for a card, which is
    // the default behaviour of the PN532.
    nfc.setPassiveActivationRetries(0xFF);
 
    // configure board to read RFID tags
    nfc.SAMConfig();
 
    pc.printf ("\nWaiting for an ISO14443A card\n");
}
 
 
/*==============================================================================
 * \brief find a tag
 */
void loop(void)
{
    bool success;
    uint8_t uid[] = { 0, 0, 0, 0, 0, 0, 0 };  // Buffer to store the returned UID
    uint8_t uidLength;  // Length of the UID (4 or 7 bytes depending on ISO14443A card type)
 
    // configure board to read RFID tags
    nfc.SAMConfig();
 
    // Wait for an ISO14443A type cards (Mifare, etc.).  When one is found
    // 'uid' will be populated with the UID, and uidLength will indicate
    // if the uid is 4 bytes (Mifare Classic) or 7 bytes (Mifare Ultralight)
    success = nfc.readPassiveTargetID(PN532_MIFARE_ISO14443A, &uid[0], &uidLength);
 
    printf ("\n");
 
    if (success) {     
        ledNFC = 1;             // led on
        
        pc.printf("Found a card!\n");
 
        pc.printf("UID Length: %d bytes\n", uidLength);
        pc.printf("UID Value: ");
        //int id = 0; //create a variable to build the user id into
        for (uint8_t i=0; i < uidLength; i++)
        {
            pc.printf("%d",uid[i]); 
        }
        pc.printf("\r\n");
        
        
        /* COMPUTER SCIENCE GROUP CHAT OPTION 
        int result = 0;
        for (int i = 0; i < uidLength; i++) {
        result = result + (uid[i] * pow(10.0, (uidLength-i)-1));
        }
        pc.printf("Result: %d \r\n",result);
        */
        
        // DAVID BARNES OPTION
        unsigned long sum = 0;
        for(int i = 0; i < sizeof(uid) / sizeof(*uid); i++) {
             sum = (sum * 10) + uid[i];
        }
        printf("Sum: %lu", sum);
        
        /* ONLINE FORUM OPTION
        uint32_t cardidentifier = 0;
        cardidentifier = uid[0];
        cardidentifier >>= 8; cardidentifier |= uid[1];
        cardidentifier >>= 8; cardidentifier |= uid[2];
        cardidentifier >>= 8; cardidentifier |= uid[3];
        pc.printf("My number: %u \r\n",cardidentifier);
        */
        pc.printf("Correct number %u \r\n", acceptedCard);
        
        wait_ms (100);
        ledNFC = 0; //turn off red and turn on green
        //green led to show it is the right card
        // wait until the card is taken away
        while (nfc.readPassiveTargetID(PN532_MIFARE_ISO14443A, &uid[0], &uidLength, 500)) {}
 
        ledNFC = 0;         // led off
    } else {
        // PN532 probably timed out waiting for a card
        pc.printf("\nTimed out waiting for a card\n");
        ledNFC = 0;
        wait_ms (200);
    }
}
 
 
/*==============================================================================
 * \brief main entry
 */
int main()
{
    setup();
 
    while (1)
        loop ();
}