/*
 * (C) The University of Kent and Simon Cooksey 2015.
 */
 
#include "mbed.h"
 
#include "dht22.h"
 
Serial host(USBTX, USBRX);
DHT22 dht22(PTB18);
 
 
int main()
{
    host.baud(38400);
    DHT22_data_t dht22_data;
    host.printf("\r\n\r\nhello world\r\n");
    while (true) {
        dht22.read(&dht22_data);
        
        float temperature = dht22_data.temp / 10.0f;
        float humidity = dht22_data.humidity / 10.0f;
        
        int check = (dht22_data.humidity/10) + (dht22_data.humidity%10) + (dht22_data.temp/10) + (dht22_data.temp%10);
        
        //host.lock ();
//        host.printf("Temperature: %2.2f    Humidity: %2.2f%%\r\n", temperature, humidity);//, dht22_data.checksum, 0xff & check);
        host.printf("Temperature: %d (%2.2f)   Humidity: %d (%2.2f)\r\n", dht22_data.temp, temperature, dht22_data.humidity, humidity);//, dht22_data.checksum, 0xff & check);
        //host.unlock ();
        
//        host.printf("0x%04X\t\t0x%04X\t\t0x%02X\r\n", 0xFFFF & dht22_data.temp, 0xFFFF & dht22_data.humidity, 0xFF & dht22_data.checksum);
        
        wait_ms(1000);
    }
}