#include "mbed.h"
#include "C12832.h"                     /* for the LCD */
#include "LM75B.h"                      /* for the temperature sensor */
#include "MMA7660.h"
#include "stdio.h"   



DigitalOut xr_led (LED1); /* red LED */
DigitalOut xg_led (LED2); /* green LED */
DigitalOut xb_led (LED3); /* blue LED  */


PwmOut intr_alarm(D6) ;

InterruptIn sw2_int (PTC6);             /* interrupt for sw2 button on mbed */
InterruptIn sw3_int (PTA4);              /* interrupt for sw3 button on mbed */

Serial host (USBTX, USBRX);             /* to-host UART via OpenSDAv2 *///

MMA7660 MMA(D14, D15); /* accelerometer */

C12832 shld_lcd (D11, D13, D12, D7, D10);   /* LCD on the shield (128x32) */

static volatile int triggered = 0;      /* variable to decide whether alarm has been triggred */


float x,y,z;          /* float variables for acceleromter */



void sw3_interrupt (void)   /* this method disarms the motion detector alarm  */
{
    triggered = 0;
    xr_led = 1;
 xg_led  =1;
 xb_led  =1;
 
 shld_lcd.cls();
 shld_lcd.locate(0,0);
 shld_lcd.printf ("Disarmed");
 
}


void sw2_interrupt (void)           /* this method checks if the sw2 buttin has been pressed.If so It arsm the motion sendsor  */
{
   if (triggered == 0) { x=MMA.x();
    y=MMA.y();
    z=MMA.z();
    
    triggered = 1;
    
    shld_lcd.cls();
    shld_lcd.locate(0,0);
    shld_lcd.printf ("Armed");
    

    } 
    }

/* Main code stars here  */



int main (void ) 
{

shld_lcd.printf ("Disarmed");     /* LCD Shows that alarm is initially disarmed  */


 xr_led = 1;                       /* LED lights are off to begin with   */
 xg_led  =1;
 xb_led  =1;
 

    
    sw2_int.mode (PullUp);              /*   */
    sw2_int.fall (&sw2_interrupt);
    
    sw3_int.mode (PullUp);
    sw3_int.fall (&sw3_interrupt);
    
    
  while (true) {     /*  check if there is a difference in acclorometer position */
    
    if (triggered ==1) {     /* when armed   */
      float px = MMA.x(); float py = MMA.y(); float pz = MMA.z();         
       float diff = abs(x-px) + abs(y-py) + abs(z-pz);
        if (diff>0.3f) { /* difference check occurs here  */
        
        shld_lcd.locate(0,0);
        shld_lcd.printf ("Intruder Detected");   /* intruduer detected LCD code   */
        
        
        /* Alarm triggered here once intruder has been detected  */
          
          while (triggered ==1){          
        for (float i=2000.0; i<10000.0; i+=100) {
                        float f = i;
                        intr_alarm.period(1.0/f);
                        intr_alarm=0.7;
                        wait(0.005);
                }
                
   /* Different colours for LED when Intruder detected   */             
            intr_alarm=0.0;
            xr_led = 0;
           
            
            wait(0.5);          
            
            xr_led = 1;
           
            
            
            
            xg_led  =0;
           
            
            wait(0.5);               /* led particular light colour displays for 0.5 secs  */
            
            xg_led  =1;
            
            
            
            xb_led  =0;
             
             
             wait(0.5);
             
             xb_led  =1;
           
             }
            }                
                
  
     }
     
     }
}