/*
 *  g3d_textures.h -- some sample textures for G3D
 *  Fred Barnes, 2015
 */

#ifndef __G3D_TEXTURES_H
#define __G3D_TEXTURES_H

/* Note: the orientation of textures is sideways, starting at the top-left (0,0) each vertical strip of 32 pixels (4 bytes) */
uint8_t g3d_texture_check[128] = {
        0x0f, 0x0f, 0x0f, 0x0f,     0x0f, 0x0f, 0x0f, 0x0f,
        0x0f, 0x0f, 0x0f, 0x0f,     0x0f, 0x0f, 0x0f, 0x0f,
        0xf0, 0xf0, 0xf0, 0xf0,     0xf0, 0xf0, 0xf0, 0xf0,
        0xf0, 0xf0, 0xf0, 0xf0,     0xf0, 0xf0, 0xf0, 0xf0,
        0x0f, 0x0f, 0x0f, 0x0f,     0x0f, 0x0f, 0x0f, 0x0f,
        0x0f, 0x0f, 0x0f, 0x0f,     0x0f, 0x0f, 0x0f, 0x0f,
        0xf0, 0xf0, 0xf0, 0xf0,     0xf0, 0xf0, 0xf0, 0xf0,
        0xf0, 0xf0, 0xf0, 0xf0,     0xf0, 0xf0, 0xf0, 0xf0,
        0x0f, 0x0f, 0x0f, 0x0f,     0x0f, 0x0f, 0x0f, 0x0f,
        0x0f, 0x0f, 0x0f, 0x0f,     0x0f, 0x0f, 0x0f, 0x0f,
        0xf0, 0xf0, 0xf0, 0xf0,     0xf0, 0xf0, 0xf0, 0xf0,
        0xf0, 0xf0, 0xf0, 0xf0,     0xf0, 0xf0, 0xf0, 0xf0,
        0x0f, 0x0f, 0x0f, 0x0f,     0x0f, 0x0f, 0x0f, 0x0f,
        0x0f, 0x0f, 0x0f, 0x0f,     0x0f, 0x0f, 0x0f, 0x0f,
        0xf0, 0xf0, 0xf0, 0xf0,     0xf0, 0xf0, 0xf0, 0xf0,
        0xf0, 0xf0, 0xf0, 0xf0,     0xf0, 0xf0, 0xf0, 0xf0
    };


uint8_t g3d_texture_face[128] = {
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x81, 0xff, 0xff, 0xff, 0x00, 0xfe,
        0xff, 0xff, 0x00, 0xfc, 0x1f, 0xf8, 0x01, 0xf8, 0x0f, 0xf0, 0x3f, 0xf8,
        0x0f, 0xf0, 0x7f, 0xf0, 0x0f, 0xf0, 0x7f, 0xf0, 0x0f, 0xf0, 0xff, 0xf0,
        0x1f, 0xf8, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xf0,
        0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xf0,
        0xff, 0xff, 0xff, 0xf0, 0x1f, 0xf8, 0xff, 0xf0, 0x0f, 0xf0, 0xff, 0xf0,
        0x0f, 0xf0, 0x7f, 0xf0, 0x0f, 0xf0, 0x7f, 0xf0, 0x0f, 0xf0, 0x3f, 0xf8,
        0x1f, 0xf8, 0x01, 0xf8, 0xff, 0xff, 0x00, 0xfc, 0xff, 0xff, 0x00, 0xfe,
        0xff, 0xff, 0x81, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
    };

uint8_t g3d_texture_hlife[128] = {
        0xff, 0x0f, 0xf0, 0xff, 0xff, 0x03, 0x80, 0xff, 0x7f, 0x00, 0x00, 0xfe,
        0x3f, 0xf8, 0x1f, 0xfc, 0x1f, 0xfe, 0x7f, 0xf8, 0x0f, 0xff, 0xff, 0xf0,
        0x87, 0xff, 0xff, 0xe1, 0xc3, 0xff, 0xff, 0xc3, 0xe3, 0xff, 0x3f, 0xc7,
        0xf1, 0xff, 0x1f, 0x8f, 0xf1, 0xff, 0x07, 0x8f, 0x39, 0xff, 0x83, 0x9f,
        0x38, 0xff, 0xc0, 0x1f, 0x38, 0x3f, 0xf0, 0x1f, 0x38, 0x1c, 0xfc, 0x1f,
        0x38, 0x00, 0xfe, 0x1f, 0x38, 0x80, 0xff, 0x1f, 0xf8, 0x01, 0xfe, 0x1f,
        0xf8, 0x07, 0xf0, 0x1f, 0xf8, 0x3f, 0x80, 0x1f, 0xf9, 0xff, 0x01, 0x9e,
        0xf1, 0xff, 0x07, 0x8e, 0xf1, 0xff, 0x1f, 0x8e, 0xe3, 0xff, 0x3f, 0xc7,
        0xc3, 0xff, 0x1f, 0xc3, 0x87, 0xff, 0xbf, 0xe1, 0x0f, 0xff, 0xff, 0xf0,
        0x1f, 0xfe, 0x7f, 0xf8, 0x3f, 0xf8, 0x1f, 0xfc, 0x7f, 0x00, 0x00, 0xfe,
        0xff, 0x01, 0x80, 0xff, 0xff, 0x0f, 0xf0, 0xff
    };

uint8_t g3d_texture_ccube[128] = {
        0x00, 0x00, 0x80, 0x00, 0xc0, 0x01, 0xe0, 0x01, 0xe0, 0x07, 0xe0, 0x03,
        0xe0, 0x07, 0xe0, 0x03, 0xe0, 0x07, 0xe0, 0x01, 0xc0, 0x07, 0x80, 0x00,
        0xf0, 0x0f, 0x38, 0x3c, 0xf8, 0x0f, 0xfc, 0x7d, 0xf8, 0x0f, 0xfc, 0x7d,
        0xf8, 0x03, 0x7c, 0x7e, 0xf0, 0x00, 0xff, 0x7e, 0x00, 0x80, 0x69, 0x0e,
        0x00, 0x80, 0x09, 0x30, 0x00, 0xc0, 0x69, 0x1c, 0x00, 0xe0, 0xfd, 0x7e,
        0xf0, 0xe0, 0xff, 0x7e, 0xf8, 0xe3, 0x7f, 0x7c, 0xfc, 0xe3, 0xff, 0x7d,
        0xfe, 0xe7, 0x7f, 0x3c, 0xfe, 0xe7, 0x33, 0x18, 0xfe, 0xe7, 0xff, 0x3b,
        0xfe, 0xe7, 0xff, 0x3d, 0xfe, 0xe7, 0xff, 0x3d, 0xfc, 0xe3, 0xff, 0x3e,
        0xf8, 0xe1, 0xff, 0x1e, 0x60, 0xe0, 0xff, 0x1e, 0x00, 0xe0, 0x3f, 0x1f,
        0x00, 0xc0, 0xff, 0x0f, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xf8, 0x07,
        0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x03
    };


uint8_t g3d_texture_wcube[128] = {
        0xf8, 0x0f, 0xf0, 0x1f, 0xfc, 0x0f, 0xf0, 0x3f, 0xfe, 0x0f, 0xf0, 0x7f,
        0xff, 0xef, 0xf7, 0xff, 0xff, 0xef, 0xf7, 0xff, 0xff, 0xef, 0xf7, 0xff,
        0xff, 0xef, 0xf7, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x77, 0xee, 0xff,
        0xff, 0x7b, 0xde, 0xff, 0xff, 0x7d, 0xbe, 0xff, 0xff, 0x7e, 0x7e, 0xff,
        0x00, 0x3f, 0xfc, 0x00, 0x78, 0x1f, 0xf8, 0x1e, 0x78, 0x0f, 0xf0, 0x1e,
        0x78, 0x00, 0x00, 0x1e, 0x78, 0x00, 0x00, 0x1e, 0x78, 0x0f, 0xf0, 0x1e,
        0x78, 0x1f, 0xf8, 0x1e, 0x00, 0x3e, 0x7c, 0x00, 0xff, 0x7d, 0x3e, 0xff,
        0xff, 0x7b, 0x9e, 0xff, 0xff, 0x77, 0xce, 0xff, 0xff, 0x6f, 0xe6, 0xff,
        0xff, 0x0f, 0xf0, 0xff, 0xff, 0xef, 0xf7, 0xff, 0xff, 0xef, 0xf7, 0xff,
        0xff, 0xef, 0xf7, 0xff, 0xfe, 0xef, 0xf7, 0x7f, 0xfc, 0x0f, 0xf0, 0x3f,
        0xf8, 0x0f, 0xf0, 0x1f, 0xf0, 0x0f, 0xf0, 0x0f
    };

#endif  /* !__G3D_TEXTURES_H */
