/*
 *  g3d_font04b.cpp -- G3D font rendering for Yuji Oshimoo's font 04b30 (www.04.jp.org)
 *  Fred Barnes, University of Kent
 */


#include "mbed.h"
#include "C12832.h"
#include "gfx3d.h"

static uint8_t font_metrics_04b[96] = {
        0xe1, 0x37, 0x2d, 0x2f, 0xe1, 0x2f, 0xe1, 0x25, 0x38, 0x47, 0x37, 0x2f, 0x25, 0x2d, 0x25, 0x2f,
        0x2f, 0x2a, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x25, 0x25, 0x2a, 0x2d, 0x2a, 0x2f,
        0xe1, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x37, 0x2f, 0x2f, 0x2e, 0x20, 0x2f, 0x2f,
        0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x20, 0x2f, 0x2f, 0x2f, 0x37, 0x2f, 0x37, 0x38, 0x2f,
        0x38, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x26, 0x2d, 0x2d, 0x2c, 0x2e, 0x2d, 0x2d,
        0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2e, 0x2d, 0x2d, 0x2d, 0x2a, 0x37, 0x2a, 0x38, 0x00,
    };

/* 2x8-bit vertical slices, LSB=topmost (big-endian pairs) */
static uint8_t font_data_04b[96*32] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x3c, 0x71, 0xe2, 0xfb, 0xfa, 0xfb, 0xfa, 0xfb, 0xfe, 0x71, 0xfe, 0x00, 0x3c, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x01, 0xf8, 0x03, 0xc4, 0x03, 0xf4, 0x03, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf8,
        0x03, 0xc4, 0x03, 0xf4, 0x03, 0xf4, 0x03, 0xfc, 0x01, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x60, 0x18, 0xe0, 0x7f, 0xfc, 0xff, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0x7f, 0xfc, 0x08, 0xe0,
        0x7f, 0xfc, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x18, 0xe0, 0x00, 0x60, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x70, 0x1c, 0xf8, 0x22, 0xfe, 0x3a, 0xfe, 0x3a, 0x7f, 0x1c, 0x3f, 0xc0, 0x3f, 0xc0, 0x1f, 0xe0,
        0x07, 0xf8, 0x07, 0xf8, 0x71, 0xfc, 0xf8, 0xfe, 0xf8, 0xfe, 0xf8, 0x3e, 0x70, 0x1c, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x01, 0xf8, 0x03, 0xc4, 0x03, 0xf4, 0x03, 0xf4, 0x01, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x07, 0x80, 0x3f, 0xf0, 0x3f, 0xf8, 0x7f, 0xf0, 0xff, 0xfa, 0xf8, 0x7e, 0xf0, 0x1e, 0x60, 0x0c,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x70, 0x0c, 0xf0, 0x12, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x0f, 0xf0, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xdc, 0x01, 0xe2, 0x01, 0xfa, 0x01, 0xfa, 0x00, 0xfc, 0x01, 0xfe, 0x00, 0xdc, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x03, 0x00, 0x07, 0xc0, 0x07, 0xc0, 0x07, 0xc0, 0x7f, 0xfc, 0xff, 0xe2, 0xff, 0xfa, 0xff, 0xfa,
        0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x07, 0xc0, 0x07, 0xc0, 0x07, 0xc0, 0x03, 0x00, 0x00, 0x00,
        0x7c, 0x00, 0xe2, 0x00, 0xfa, 0x00, 0xfa, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x07, 0x00, 0x08, 0xc0, 0x0e, 0xc0, 0x0e, 0xc0, 0x0f, 0xc0, 0x0f, 0xc0, 0x0f, 0xc0, 0x0f, 0xc0,
        0x0f, 0xc0, 0x0f, 0xc0, 0x0f, 0xc0, 0x0f, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x38, 0x00, 0x44, 0x00, 0x74, 0x00, 0x74, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x70, 0x00, 0xf8, 0x00, 0xfc, 0x00, 0xfe, 0x00, 0x7f, 0x00, 0x3f, 0xc0, 0x1f, 0xe0, 0x0f, 0xf0,
        0x07, 0xf8, 0x07, 0xf8, 0x03, 0xfc, 0x01, 0xfe, 0x00, 0xfe, 0x00, 0x3e, 0x00, 0x1c, 0x00, 0x00,
        0x3f, 0xf8, 0x7f, 0xf0, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
        0xf0, 0x0e, 0xf0, 0x0e, 0xf0, 0x0e, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x00, 0x00,
        0x00, 0x1c, 0x00, 0x02, 0x7f, 0xfa, 0x7f, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
        0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0x1c, 0xff, 0x02, 0xff, 0xda, 0xff, 0xda, 0xff, 0xde, 0xff, 0xde, 0xff, 0xde, 0xfb, 0xde,
        0xfb, 0xde, 0xfb, 0xde, 0xfb, 0xfe, 0xfb, 0xfe, 0xfb, 0xfe, 0xf8, 0xfc, 0x70, 0xf8, 0x00, 0x00,
        0x30, 0x08, 0x78, 0x10, 0xfb, 0xda, 0xfb, 0xde, 0xfb, 0xde, 0xfb, 0xde, 0xfb, 0xde, 0xfb, 0xde,
        0xfb, 0xde, 0xfb, 0xde, 0xfb, 0xde, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x00, 0x00,
        0x07, 0xfc, 0x0f, 0xe2, 0x1f, 0xfa, 0x1f, 0xfa, 0x1f, 0xfe, 0x1f, 0xfc, 0x1e, 0x00, 0x7f, 0xfc,
        0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x1e, 0x00, 0x0c, 0x00, 0x00, 0x00,
        0x71, 0xfc, 0xfb, 0xe2, 0xfb, 0xfa, 0xfb, 0xfa, 0xfb, 0xfe, 0xfb, 0xfe, 0xfb, 0xfe, 0xfb, 0xde,
        0xfb, 0xde, 0xfb, 0xde, 0xff, 0xde, 0xff, 0xde, 0xff, 0xde, 0x7f, 0x1e, 0x3e, 0x1c, 0x00, 0x00,
        0x3f, 0xf8, 0x7f, 0xf0, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
        0xf1, 0x8e, 0xf1, 0x8e, 0xf1, 0x8e, 0xff, 0x8e, 0xff, 0x8e, 0x7f, 0x04, 0x3e, 0x00, 0x00, 0x00,
        0x00, 0x1c, 0x00, 0x02, 0x00, 0x1a, 0x00, 0x1a, 0x7e, 0x1e, 0xff, 0x1e, 0xff, 0xde, 0xff, 0xfe,
        0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfe, 0x01, 0xfe, 0x01, 0xfe, 0x00, 0xfe, 0x00, 0x3c, 0x00, 0x00,
        0x3e, 0xf8, 0x7f, 0xf0, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
        0xf1, 0x8e, 0xf1, 0x8e, 0xf1, 0x8e, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x3e, 0xf8, 0x00, 0x00,
        0x00, 0xf8, 0x01, 0xf0, 0x03, 0xfa, 0x43, 0xfe, 0xe3, 0xfe, 0xe3, 0xfe, 0xfb, 0xfe, 0xfb, 0xfe,
        0x7f, 0x8e, 0x7f, 0x8e, 0x3f, 0x8e, 0x1f, 0xfe, 0x1f, 0xfe, 0x07, 0xfc, 0x01, 0xf8, 0x00, 0x00,
        0x3c, 0x38, 0x78, 0xc4, 0x78, 0xf4, 0x78, 0xf4, 0x3c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7e, 0x1c, 0xfc, 0x62, 0xfc, 0x7a, 0xfc, 0x7a, 0x7e, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x07, 0x80, 0x0f, 0xe0, 0x0f, 0xe0, 0x3f, 0xf8, 0x7f, 0xe0, 0xfc, 0x7a, 0xfc, 0x7a, 0xf0, 0x1e,
        0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x38, 0x38, 0x7c, 0x44, 0x7c, 0x74, 0x7c, 0x74, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
        0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x60, 0x1c, 0xe0, 0x02, 0xf8, 0x3a, 0xf8, 0x3a, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xe0, 0x0f, 0xf0,
        0x07, 0xc0, 0x07, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x1c, 0x00, 0x02, 0x00, 0x1a, 0x00, 0x1a, 0x70, 0x1e, 0xfd, 0xde, 0xfd, 0xde, 0xfd, 0xde,
        0x71, 0xde, 0x71, 0xde, 0x01, 0xfe, 0x01, 0xfe, 0x01, 0xfe, 0x00, 0xfc, 0x00, 0xf8, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf8, 0xff, 0xf0, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfe,
        0x01, 0x8e, 0x01, 0x8e, 0x01, 0x8e, 0x7f, 0xfe, 0xff, 0xfc, 0xff, 0xf8, 0x7f, 0xf0, 0x00, 0x00,
        0x7f, 0xfe, 0xff, 0xf0, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
        0xf1, 0x8e, 0xf1, 0x8e, 0xf1, 0x8e, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfe, 0x3e, 0xfc, 0x00, 0x00,
        0x3f, 0xf8, 0x7f, 0xf0, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xf0, 0x0e,
        0xf0, 0x0e, 0xf0, 0x0e, 0xf0, 0x0e, 0xf0, 0x0e, 0xf0, 0x0e, 0xf0, 0x0e, 0x60, 0x04, 0x00, 0x00,
        0x7f, 0xfc, 0xff, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
        0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xff, 0xfe, 0xff, 0xfc, 0x7f, 0xf8, 0x3f, 0xe0, 0x00, 0x00,
        0x7f, 0xfe, 0xff, 0xf0, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xf1, 0x8e,
        0xf1, 0x8e, 0xf1, 0x8e, 0xf1, 0x8e, 0xf1, 0x8e, 0xf1, 0x8e, 0xf1, 0x8e, 0x61, 0xc6, 0x00, 0x00,
        0x7f, 0xfe, 0xff, 0xf0, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfe, 0x03, 0x8e,
        0x03, 0x8e, 0x03, 0x8e, 0x03, 0x8e, 0x03, 0x8e, 0x03, 0x8e, 0x03, 0x8e, 0x01, 0xc6, 0x00, 0x00,
        0x3f, 0xf8, 0x7f, 0xf0, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
        0xf0, 0x0e, 0xf1, 0x8e, 0xf1, 0x8e, 0xff, 0x8e, 0xff, 0x8e, 0x7f, 0x8e, 0x3f, 0x84, 0x00, 0x00,
        0x7f, 0xfc, 0xff, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x03, 0xc0,
        0x03, 0xc0, 0x03, 0xc0, 0x7f, 0xfc, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x00, 0x00,
        0x7f, 0xfc, 0xff, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x3e, 0x00, 0x7f, 0x00, 0xff, 0x00, 0xff, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xff, 0xfc,
        0xff, 0xfc, 0xff, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0x7f, 0xfe, 0x3f, 0xfc, 0x00, 0x00,
        0x7f, 0xfc, 0xff, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc,
        0x0f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0, 0x7f, 0xfc, 0xfe, 0xfe, 0xfc, 0x7e, 0x70, 0x1c, 0x00, 0x00,
        0x7f, 0xfc, 0xff, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfc, 0xf0, 0x00,
        0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xfc, 0xff, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0x7f, 0xfc, 0x7f, 0xfc, 0x0f, 0xc0,
        0x1f, 0x00, 0x1f, 0x00, 0x0f, 0xc0, 0x7f, 0xfc, 0x7f, 0xfc, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc,
        0x7f, 0xfc, 0xff, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x07, 0xc0,
        0x0f, 0x00, 0x7f, 0xfc, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x00, 0x00,
        0x3f, 0xf8, 0x7f, 0xf0, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
        0xf0, 0x0e, 0xf0, 0x0e, 0xf0, 0x0e, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x00, 0x00,
        0x7f, 0xfc, 0xff, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfe, 0x0e, 0x1e,
        0x0e, 0x1e, 0x0e, 0x1e, 0x0f, 0xfe, 0x0f, 0xfe, 0x0f, 0xfe, 0x07, 0xfc, 0x03, 0xf8, 0x00, 0x00,
        0x0f, 0xfe, 0x1f, 0xfc, 0x3f, 0xfe, 0x3f, 0xff, 0x3f, 0xff, 0x3f, 0xff, 0x3f, 0xff, 0x3f, 0xff,
        0xfc, 0x03, 0xfc, 0x03, 0xfc, 0x03, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xff, 0x0f, 0xfe, 0x00, 0x00,
        0x7f, 0xfe, 0xff, 0xf0, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfe,
        0x0f, 0x8e, 0x1f, 0x8e, 0x1f, 0x8e, 0x7f, 0xfe, 0xff, 0xfe, 0xfd, 0xfe, 0x78, 0xfc, 0x00, 0x00,
        0x71, 0xf8, 0xfb, 0xf0, 0xfb, 0xfa, 0xfb, 0xfe, 0xfb, 0xfe, 0xfb, 0xfe, 0xfb, 0xfe, 0xfb, 0xde,
        0xfb, 0xde, 0xfb, 0xde, 0xff, 0xde, 0xff, 0xde, 0xff, 0xde, 0x7f, 0xde, 0x3f, 0x8c, 0x00, 0x00,
        0x00, 0x1c, 0x00, 0x02, 0x00, 0x1a, 0x00, 0x1a, 0x7f, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
        0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfe, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1c, 0x00, 0x00,
        0x3f, 0xfc, 0x7f, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfc, 0xf0, 0x00,
        0xf0, 0x00, 0xf0, 0x00, 0xff, 0xfc, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfe, 0x3f, 0xfc, 0x00, 0x00,
        0x3f, 0xfc, 0x7f, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfc, 0xfc, 0x00,
        0x7e, 0x00, 0x7e, 0x00, 0x3f, 0xfc, 0x1f, 0xfe, 0x0f, 0xfe, 0x07, 0xfe, 0x03, 0xfc, 0x00, 0x00,
        0x7f, 0xfc, 0xff, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x7f, 0xfc,
        0x3e, 0x00, 0x1f, 0x00, 0x3e, 0x00, 0x7f, 0xfc, 0x7f, 0xfc, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc,
        0x40, 0x1c, 0xfc, 0x22, 0xf8, 0xfa, 0x78, 0xfc, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xe0, 0x1f, 0xe0,
        0x1f, 0xe0, 0x7f, 0xfc, 0x7f, 0xfc, 0x7f, 0xfc, 0xf8, 0xfe, 0xfc, 0x3e, 0x40, 0x1c, 0x00, 0x00,
        0x00, 0x1c, 0x00, 0x72, 0x00, 0xfa, 0x01, 0xfe, 0x7f, 0xfe, 0xff, 0xfc, 0xff, 0xf8, 0xff, 0xf8,
        0xff, 0xfc, 0xff, 0xfc, 0x7f, 0xfe, 0x01, 0xfe, 0x00, 0xfe, 0x00, 0x7e, 0x00, 0x1c, 0x00, 0x00,
        0x70, 0x1c, 0xf8, 0x02, 0xfc, 0x1a, 0xfc, 0x1a, 0xff, 0x1e, 0xff, 0xde, 0xff, 0xfe, 0xff, 0xfe,
        0xff, 0xfe, 0xff, 0xfe, 0xfb, 0xfe, 0xf8, 0xfe, 0xf8, 0xfe, 0xf8, 0x3e, 0x70, 0x1c, 0x00, 0x00,
        0x3f, 0xf8, 0x7f, 0xe0, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xf0, 0x3e, 0x70, 0x1c, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x1c, 0x00, 0x22, 0x00, 0xfa, 0x00, 0xfa, 0x03, 0xfc, 0x07, 0xf8, 0x0f, 0xe0, 0x1f, 0xe0,
        0x3f, 0xc0, 0x3f, 0xc0, 0x7f, 0x00, 0xfe, 0x00, 0xfc, 0x00, 0xf8, 0x00, 0x70, 0x00, 0x00, 0x00,
        0x60, 0x1c, 0xf0, 0x02, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x38, 0x00, 0xc4, 0x00, 0xf4, 0x00, 0xf4, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0x38,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x70, 0x00, 0x88, 0x00, 0xe8, 0x00, 0xe8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00,
        0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x70, 0x00, 0x00, 0x00,
        0x00, 0x38, 0x00, 0xc4, 0x00, 0xf4, 0x00, 0xf4, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0x38,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xe0, 0xff, 0xc0, 0xff, 0xe8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0x7f, 0xf8, 0x07, 0xb8,
        0x07, 0xb8, 0x07, 0xb8, 0x7f, 0xf8, 0xff, 0xf0, 0x7f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf0, 0xff, 0x88, 0xff, 0xe8, 0xff, 0xe8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xf7, 0x78,
        0xf7, 0x78, 0xf7, 0x78, 0xff, 0xf8, 0x7f, 0xf0, 0x3d, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x3f, 0xe0, 0x7f, 0xc0, 0xff, 0xe8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xf8, 0x38, 0xf8, 0x38,
        0xf8, 0x38, 0xf8, 0x38, 0xf8, 0x38, 0xf8, 0x38, 0x60, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf0, 0xff, 0x88, 0xff, 0xe8, 0xff, 0xe8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xf0, 0x78,
        0xf0, 0x78, 0xf0, 0x78, 0xff, 0xf0, 0x7f, 0xe0, 0x3f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf0, 0xff, 0xc8, 0xff, 0xe8, 0xff, 0xe8, 0xff, 0xf8, 0xff, 0xf8, 0xf7, 0xb8, 0xf7, 0xb8,
        0xf7, 0xb8, 0xf7, 0xb8, 0xf7, 0xb8, 0xf7, 0xb8, 0x63, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf0, 0xff, 0xc8, 0xff, 0xe8, 0xff, 0xe8, 0xff, 0xf8, 0x7f, 0xf8, 0x07, 0xb8, 0x07, 0xb8,
        0x07, 0xb8, 0x07, 0xb8, 0x07, 0xb8, 0x07, 0xb8, 0x03, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x3f, 0xe0, 0x7f, 0xc0, 0xff, 0xe8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xf0, 0x38,
        0xf0, 0x38, 0xf2, 0x38, 0xff, 0xb8, 0x7f, 0xb8, 0x3e, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf0, 0xff, 0x88, 0xff, 0xe8, 0xff, 0xe8, 0x7f, 0xf0, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00,
        0x7f, 0xf0, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf0, 0xff, 0x88, 0xff, 0xe8, 0xff, 0xe8, 0xff, 0xf8, 0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x3c, 0x00, 0x7e, 0x00, 0xfe, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xff, 0xf0, 0xff, 0x88,
        0xff, 0xe8, 0xff, 0xe8, 0xff, 0xf8, 0x7f, 0xf8, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf0, 0xff, 0x88, 0xff, 0xe8, 0xff, 0xe8, 0xff, 0xf8, 0xff, 0xf8, 0x1f, 0x80, 0x3f, 0xe0,
        0x3f, 0xe0, 0x7f, 0xf0, 0xfd, 0xf8, 0xf8, 0xf8, 0x60, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf0, 0xff, 0x88, 0xff, 0xe8, 0xff, 0xe8, 0xff, 0xf8, 0xff, 0xf0, 0xf0, 0x00, 0xf0, 0x00,
        0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf0, 0xff, 0x88, 0xff, 0xe8, 0xff, 0xe8, 0x7f, 0xf0, 0x7f, 0xf0, 0x07, 0x80, 0x0f, 0x00,
        0x0f, 0x00, 0x07, 0x80, 0x7f, 0xf0, 0x7f, 0xf0, 0xff, 0xf8, 0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf0, 0xff, 0x88, 0xff, 0xe8, 0xff, 0xe8, 0xff, 0xf8, 0x7f, 0xf0, 0x03, 0x80, 0x07, 0x00,
        0x7f, 0xf0, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x3f, 0xe0, 0x7f, 0xc0, 0xff, 0xe8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xf8, 0x38,
        0xf8, 0x38, 0xf8, 0x38, 0xff, 0xf8, 0x7f, 0xf0, 0x3f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf0, 0xff, 0xc8, 0xff, 0xe8, 0xff, 0xe8, 0xff, 0xf8, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38,
        0x0f, 0xf8, 0x0f, 0xf8, 0x0f, 0xf8, 0x07, 0xf0, 0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0f, 0xf8, 0x1f, 0xf0, 0x3f, 0xfa, 0x3f, 0xfe, 0x3f, 0xfe, 0x3f, 0xfe, 0x3f, 0xfe, 0xfe, 0x0e,
        0xfe, 0x0e, 0xfe, 0x0e, 0xff, 0xfe, 0x1f, 0xfc, 0x0f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf0, 0xff, 0xc8, 0xff, 0xe8, 0xff, 0xe8, 0xff, 0xf8, 0xff, 0xf8, 0x0f, 0xb8, 0x1f, 0xb8,
        0x1f, 0xb8, 0x7f, 0xf8, 0x7f, 0xf8, 0xfb, 0xf0, 0x71, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x71, 0xe0, 0xfb, 0xc0, 0xfb, 0xe8, 0xfb, 0xf8, 0xfb, 0xf8, 0xfb, 0xf8, 0xfb, 0xb8, 0xfb, 0xb8,
        0xff, 0xb8, 0xff, 0xb8, 0xff, 0xb8, 0x7f, 0xb8, 0x3e, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x70, 0x00, 0x88, 0x00, 0xe8, 0x00, 0xe8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8,
        0x7f, 0xf8, 0x7f, 0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x3f, 0xf0, 0x7f, 0x88, 0xff, 0xe8, 0xff, 0xe8, 0xff, 0xf0, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
        0xff, 0xf0, 0xff, 0xf8, 0xff, 0xf8, 0x7f, 0xf8, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x3f, 0xf0, 0x7f, 0x88, 0xff, 0xe8, 0xff, 0xe8, 0xff, 0xf8, 0xff, 0xf0, 0xf8, 0x00, 0x7c, 0x00,
        0x7c, 0x00, 0x3f, 0xf0, 0x1f, 0xf8, 0x0f, 0xf8, 0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xf0, 0xff, 0x88, 0xff, 0xe8, 0xff, 0xe8, 0x7f, 0xf0, 0x7f, 0xf0, 0x3c, 0x00, 0x1e, 0x00,
        0x3c, 0x00, 0x7f, 0xf0, 0x7f, 0xf0, 0xff, 0xf8, 0xff, 0xf8, 0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00,
        0x40, 0xf0, 0xf1, 0x88, 0xfb, 0xe8, 0xfb, 0xe8, 0x7f, 0xe0, 0x3f, 0x80, 0x1f, 0xe0, 0x3f, 0xf0,
        0x7f, 0xf8, 0x7f, 0xf8, 0xfd, 0xf8, 0xf8, 0xf8, 0x70, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x70, 0x00, 0x88, 0x01, 0xe8, 0x01, 0xe8, 0x7f, 0xf0, 0xff, 0xe0, 0xff, 0xe0, 0xff, 0xe0,
        0x7f, 0xf0, 0x7f, 0xf8, 0x01, 0xf8, 0x00, 0xf8, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x40, 0x70, 0xf0, 0x88, 0xf8, 0xe8, 0xf8, 0xe8, 0xfe, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8,
        0xfb, 0xf8, 0xfb, 0xf8, 0xf9, 0xf8, 0xf8, 0xf8, 0x70, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x03, 0x00, 0x07, 0xc0, 0x3f, 0xf8, 0x7f, 0xf0, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0xf0, 0x1e,
        0x60, 0x0c, 0x60, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x7f, 0xfc, 0xff, 0xe2, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xfc, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x60, 0x1c, 0xf0, 0x02, 0xff, 0xfa, 0xff, 0xfa, 0xff, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x07, 0xc0,
        0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x38, 0x00, 0xc4, 0x00, 0xf4, 0x00, 0xf4, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0x38,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    };


int gfx3d_font04b_char_dpw (const char ch)
{
    int sel, cw, sw;

    if ((ch < 32) || (ch > 127)) {
        return 0;
    }
    sel = ch - 32;
    cw = (font_metrics_04b[sel] & 0x0f);
    if (!cw) {
        cw = 16;
    }
    sw = (font_metrics_04b[sel] >> 4) & 0x0f;
    if (!sw) {
        sw = 16;
    }
    return cw + sw;
}


void gfx3d_font04b_tx_putchar (uint8_t *txbuf, const int txwidth, int *xptr, const int y, const char ch, const bool inv)
{
    int sel, cw, sw, i, dcs, dcw;
    
    if ((ch < 32) || (ch > 127)) {
        return;
    }
    sel = ch - 32;
    cw = (font_metrics_04b[sel] & 0x0f);
    if (!cw) {
        cw = 16;
    }
    sw = (font_metrics_04b[sel] >> 4) & 0x0f;
    if (!sw) {
        sw = 16;
    }
    
    if (*xptr >= txwidth) {
        *xptr += cw+sw;     /* advance space but do nothing else */
        return;
    } else if ((*xptr + cw) < 0) {
        /* all character data off-left, advance space and nothing else */
        *xptr += cw+sw;
        return;
    }
    sel <<= 5;              /* in 32-byte steps */
    
    if ((*xptr + cw) > txwidth) {
        /* means it won't all fit */
        dcw = (txwidth - *xptr);
    } else {
        dcw = cw;
    }
    if (*xptr < 0) {
        dcs = -*xptr;
    } else {
        dcs = 0;
    }
    
    /* copy in character data */
    for (i=dcs; i<dcw; i++) {
        uint8_t chigh = font_data_04b[sel + (i << 1) + 0];
        uint8_t clow = font_data_04b[sel + (i << 1) + 1];
        
        if (inv) {
            chigh = ~chigh;
            clow = ~clow;
        }
        
        if (y == 0) {
            txbuf[((*xptr + i) << 2) + 0] = clow;
            txbuf[((*xptr + i) << 2) + 1] = chigh;
        } else if (y == 8) {
            txbuf[((*xptr + i) << 2) + 1] = clow;
            txbuf[((*xptr + i) << 2) + 2] = chigh;
        } else if (y == 16) {
            txbuf[((*xptr + i) << 2) + 2] = clow;
            txbuf[((*xptr + i) << 2) + 3] = chigh;
        } else {
            /* FIXME: all the other cases */
        }
    }
    *xptr += cw + sw;

    return;
}


void gfx3d_font04b_tx_putstr (uint8_t *txbuf, const int txwidth, int *xptr, const int y, const char *str, const bool inv)
{
    const char *ch;
    
    for (ch=str; (*ch != '\0'); ch++) {
        gfx3d_font04b_tx_putchar (txbuf, txwidth, xptr, y, *ch, inv);
    }
    return;
}


void gfx3d_font04b_tx_putstrn (uint8_t *txbuf, const int txwidth, int *xptr, const int y, const char *str, const int slen, const bool inv)
{
    const char *ch;
    int left = slen;
    
    for (ch=str; (*ch != '\0') && left; ch++, left--) {
        gfx3d_font04b_tx_putchar (txbuf, txwidth, xptr, y, *ch, inv);
    }
    return;
}

