/** 
    CO657 Assessment 5 - Aggregation and Visualisation - SmartPlant
    https://moodle.kent.ac.uk/2015/mod/resource/view.php?id=190889

    Plant Code End point device.
    Reads from LM75B temperature device and sends over Xbee to broker device.
    Receives commands from broker and frontend. These commands effect the speaker and the RGB light.

    Copyright (C) Frederick Harrington(fh98) and Harry Jones(hj80), University Of Kent
    24/01/2016 **/

/** Libraries used **/
#include "mbed.h"
#include "C12832.h"
#include "LM75B.h"

/** Hardware declarations used **/
LM75B tempSen (D14, D15);
PwmOut light (D9);
C12832 lcd (D11, D13, D12, D7, D10);
Serial xbee (D1, D0);
PwmOut spkr(D6);
InterruptIn sw2_int (PTC6);
char* name = "Plant1";
static volatile int sw2_trig;
int spkr_Alrt;

//Interrupt function
void sw2_interrupt (void) {
    sw2_trig = 1;
}

/** Main method **/
int main() {
    //Method declarations 
    double temp = tempSen.read(); 
    double average = 0.0;
    int counter = 1.0;
    double last = 0.0;
    double change = 0.0;
    double sum = 0.0;      
    spkr.period(0.5);
    sw2_int.mode (PullUp);
    sw2_int.fall (&sw2_interrupt);
    
    //Main Infinate Loop
    while(true) { 
        wait(1.0);
        //Read temp from sensor
        temp = tempSen.read();
        //Print temperature over Xbee
        xbee.printf("%.2f\r\n", temp);
        
        //Calculations for average   
        sum += temp;
        average = sum / counter;
        counter++;
        
        //Displaying to LCD
        lcd.cls();
        lcd.locate(1,1);
        lcd.printf("P1");
        lcd.locate(32,1);
        lcd.printf("Temp: %.2fC\r\n", temp);
        lcd.locate(26,11);
        lcd.printf("Average: %.2fC\r\n", average);
        lcd.locate(14,21);
        //Displays either no change, increase or decrease.
        if(last > temp) {
            change = last - temp;
            lcd.printf("Temp Increase By %.2f", change);
        } else if(temp < last) {
            change = temp - last;
            lcd.printf("Temp Decreased By %.2f", change);
        } else {
            lcd.printf("No Temperature Change"); 
        }
        //Record the last sent temperature
        last = temp;       
        
        //Checks for commands and sets either the speaker or RBG light.
        if(xbee.readable()){
            //Get the command from the broker.
            char com = xbee.getc();
            
            switch(com){
            case 'a': case 'A':
                light = 1.0;
                break;
            case 'b': case 'B':
                light = 0.0;
                break;
            case 'c':case 'C':
                spkr = 1.0;
                spkr_Alrt = 1;
                break;
            case 'd': case 'D':
                spkr = 0.0;
                spkr_Alrt = 0; 
                break;
            default :
                break;
            }
        }
        //Reseting triggers on the press of SW2
        if (sw2_trig) {
            spkr_Alrt = 0;
            spkr = 0.0;
            sw2_trig = 0;
        }
        //Speaker implementations         
        if(spkr_Alrt == 1) {
            for (float i=2000.0; i<10000.0; i+=100) {
                spkr.period(1.0/i);
                spkr=0.5;
                wait(0.02); 
            }
        }
        wait(5.0);
    }       
}       
        
        
           
    