/** 
    CO657 Assessment 5 - Aggregation and Visualisation - SmartPlant
    https://moodle.kent.ac.uk/2015/mod/resource/view.php?id=190889

    Broker Mid Point Device
    Receives temperature from Xbee and sends to MQTT.
    Subscribes to commands MQTT and sends any received commands over Xbee.
    
    Copyright (C) Frederick Harrington(fh98) and Harry Jones(hj80), University Of Kent
    24/01/2016 **/

/** Libraries used **/
#include "mbed.h"
#include "C12832.h"
#include "PubSubClient.h"
#include "EthernetInterface.h"
#include <iostream>

/** Libraries used **/
C12832  lcd   (D11, D13, D12, D7, D10);
Serial  xbee  (D1, D0);
EthernetInterface   eth;
Serial pc (USBTX, USBRX);


/** Hardware declarations used **/
char* topicTopic    = "unikent/users/fh98/topics";
char* tempTopic     = "unikent/users/fh98/a5/plant";
char* commandsTopic = "unikent/users/fh98/a5/commands";
char* clientID      = "fh98";
//char* ip          = "129.12.3.210"; Not using doughnut.
char* ip            = "85.119.83.194"; //test.mosquitto.org
int port            = 1883;

//Callback for incoming messages.
void callback(char* topic, char* payload, unsigned int len){
    lcd.printf("Topic: %s\r\n", topic);
    lcd.printf("Payload: %s\r\n", payload);
    xbee.printf(payload);
}

//MQTT declarations
PubSubClient mqtt (ip, port, callback);

//Main Method
int main()
{
    //Function based declarations.
    char str[10]={10};
    eth.init();
    eth.connect();
    
    lcd.printf("Ethernet Working \r\n");
    lcd.printf("IP: %s\r\n\r\n", eth.getIPAddress());
    lcd.printf("Connecting to: \r\n");
    lcd.printf("IP: %s\r\n", ip);
    lcd.printf("Port: %d\r\n", port);
    lcd.printf("\r\n");
    wait(1.0);
    lcd.cls();
    
    bool connected = false;
    int attempts = 10;

    //While loops and if else for connecting to the MQTT server.
    while(!connected){
        if(!mqtt.connect(clientID)){
            lcd.printf("Error connecting to MQTT, try:%d\r\n", attempts);
            attempts--;
        }
        else{
            lcd.printf("Connected to MQTT\r\n\r\n");
            connected = true;
        }
        if(attempts == 0){
            lcd.printf("Failed to connect to MQTT, aborting.\r\n");
            return -1;
        }
    }
    
    //Publishing to the topic based topic.
    char buffer[150];
    sprintf(buffer, "%s\n%s\n", tempTopic, commandsTopic);
    mqtt.publish(topicTopic, buffer);
    
    //Subscribe to the commands MQTT topic.
    mqtt.subscribe(commandsTopic);
    
    //Main loop
    while (true) {
        //Reading from Xbee.
        xbee.scanf("%s", str);
        //LCD display.
        lcd.cls();
        lcd.locate(1,1);
        lcd.printf("Broker");
        lcd.locate(32,12);
        lcd.printf("Last Published");
        lcd.locate(40,21);
        lcd.printf("%sC", str);
        //Publish to the temperature topic.
        mqtt.publish(tempTopic, str);  
        wait(5.0);
        //Loop the subscribed topics. 
        mqtt.loop();
    }
}