#include "mbed.h"
#include "C12832.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"
 
// Using Arduino pin notation
C12832 lcd(D11, D13, D12, D7, D10);
DigitalIn fire(D4);
PwmOut spkr (D6);

DigitalOut r_l(D5);
DigitalOut g_l(D9);

static Serial host (USBTX, USBRX);   

/* speed we talk up the [USB] serial-port at */   
#define HOST_SPEED (38400)
 
 
 /* connection stuff for MQTT */
typedef struct S_mqtt_params {
    char *hostname;
    int port;
    char *topic;
    char *clientid;
} mqtt_params_t;


static mqtt_params_t mqtt_config = {
    hostname: "co657-mqtt.kent.ac.uk",
    port: 1883,
    topic: "unikent/users/es445/iot/register",
    clientid: "es445kent"
};


/*
 *  generates status stuff on LCD and serial
 */
static int show_status (const char *fmt, ...)
{
    va_list ap;
    int r;
    
    va_start (ap, fmt);
    r = host.vprintf (fmt, ap);
    va_end (ap);
    host.printf ("\r\n");

    lcd.fill (0, 20, 128, 12, 0);    
    lcd.locate (0, 20);
    va_start (ap, fmt);
    lcd.vprintf (fmt, ap);
    va_end (ap);
    
    return r;
}


/*
 *  does various initialisation things;  returns 0 on success, non-zero on error.
 */
static int do_setup (void)
{
    host.baud (HOST_SPEED);
    host.printf ("\r\n\r\nEthernet MQTT client from K64F\r\n");
    
    lcd.cls ();
    lcd.locate (0, 0);
    lcd.printf ("Example MQTT client\n");
    
    return 0;
}

int main()
{
    const char *ip;
    int r;
    MQTT::Message message;
    char buf[100];
    
    do_setup ();
    show_status ("Connecting to network..");

    /* Brings up the network interface */
    MQTTEthernet eth = MQTTEthernet ();
    
    ip = eth.get_ip_address();

    show_status ("IP addr is: %s", ip ?: "No address");
    
    /* Create Mbed Client Interface */
    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown> (eth);

    /* Create TCP connection */
    eth.open (eth.getEth());
    r = eth.connect (mqtt_config.hostname, mqtt_config.port);
    
    if (!r) {
        show_status ("Connected okay, start MQTT client");
        
        /* Wait for a short length of time to allow user to see output messages. */
        Thread::wait(1500);
        
        MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
        
        data.MQTTVersion = 3;
        data.clientID.cstring = mqtt_config.clientid;
        r = client.connect (data);
        
        if (!r) {
            show_status ("MQTT connected!");

     while (!r) {   
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Scan To Register");
        const char* st = "Accepted";
        while(fire) {   // this is the third thread
        show_status("Tap : %s\n",st);
        r_l = !g_l;
        wait(1.0);
        for (float i=2000.0f; i<10000.0f; i+=100) {
            spkr.period(1.0f/i);
            spkr=0.5;
            wait(0.02);
        }
        r_l = 0;
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Scan To Register");
        show_status("Tap : \n");
        
        spkr=0.0;
        sprintf (buf, "%s\n", st);                
                // QoS 0
                
                message.qos = MQTT::QOS0;
                message.retained = false;
                message.dup = false;
                message.payload = (void*)buf;
                message.payloadlen = strlen(buf)+1;
                
        r = client.publish (mqtt_config.topic, message);
        while(!fire) {}
    }

             
                if (r) {
                    show_status ("MQTT publish failed with %d", r);
                } else {
                    Thread::wait(1500);
                }
            }
        } else {
            show_status ("Failed to connect to MQTT");
        }
    } else {
        show_status ("Failed to connect (TCP)");
    }
    
    // It is good practice to close the socket
    eth.disconnect();

 
}



