// Chinese knock off Philips hue 

#include "mbed.h"

/* LEDs */
DigitalOut red_led(D5);
DigitalOut blue_led(PTC12);
DigitalOut green_led(D9);

Serial xbee(D1,D0);
Serial mac( USBTX , USBRX );

bool isLeader = false;
char group;

void ChangeColour(char rgb)
{
    bool R = rgb & 0x4;
    bool G = rgb & 0x2;
    bool B = rgb & 0x1;
    
    mac.printf("Red: %d, Green: %d, Blue %d\n",R,G,B);
    
    red_led = !R;
    green_led = !G; 
    blue_led = !B;
}

void ListenXbee(void)
{
    //read Xbee if possible \
    while (xbee.readable())
    { 
        char message = xbee.getc();
        mac.printf("%d\n",(int)message); 
        ChangeColour(message);
    }
}

int main () {
    mac.baud (38400);
    mac.printf("We are reciving\n");
    for (;;) {
        if (!isLeader) {
            ListenXbee();
        }
    wait_ms(100);
    }    
}




