/******************************************************************************
* DESCRIPTION:
*   A "hello world" CMSIS RTOS program which demonstrates another safe way
*   to pass arguments to threads during thread creation.  In this case,
*   a structure is used to pass multiple arguments.
* AUTHOR: Blaise Barney
* MODIFICATOR: (Simon) CHENG Ye
* LAST REVISED: 06/JAN/2013
******************************************************************************/

#include "mbed.h"
#include "cmsis_os.h"

#define NUM_THREADS 8

Serial debug(USBTX, USBRX);     // For mbed debug by serial port.
char *messages[NUM_THREADS];

struct thread_data
{
    int thread_id;
    int  sum;
    char *message;
};
struct thread_data thread_data_array[NUM_THREADS];

void PrintHello(void const *threadarg)
{
    int taskid, sum;
    char *hello_msg;
    struct thread_data *my_data;
    osThreadId id;

    osDelay(1000);
    my_data = (struct thread_data *) threadarg;
    taskid = my_data->thread_id;
    sum = my_data->sum;
    hello_msg = my_data->message;
    printf("Thread %d: %s  Sum=%d\n", taskid, hello_msg, sum);
    id = osThreadGetId();
    osThreadTerminate(id);
}

void t0(void const *argument) {PrintHello(argument);}
osThreadDef(t0, osPriorityNormal, DEFAULT_STACK_SIZE);

void t1(void const *argument) {PrintHello(argument);}
osThreadDef(t1, osPriorityNormal, DEFAULT_STACK_SIZE);

void t2(void const *argument) {PrintHello(argument);}
osThreadDef(t2, osPriorityNormal, DEFAULT_STACK_SIZE);

void t3(void const *argument) {PrintHello(argument);}
osThreadDef(t3, osPriorityNormal, DEFAULT_STACK_SIZE);

void t4(void const *argument) {PrintHello(argument);}
osThreadDef(t4, osPriorityNormal, DEFAULT_STACK_SIZE);

void t5(void const *argument) {PrintHello(argument);}
osThreadDef(t5, osPriorityNormal, DEFAULT_STACK_SIZE);

void t6(void const *argument) {PrintHello(argument);}
osThreadDef(t6, osPriorityNormal, DEFAULT_STACK_SIZE);

void t7(void const *argument) {PrintHello(argument);}
osThreadDef(t7, osPriorityNormal, DEFAULT_STACK_SIZE);

int main() 
{
    debug.baud(57600);
    int t, sum;

    sum=0;
    messages[0] = "English: Hello World!";
    messages[1] = "French: Bonjour, le monde!";
    messages[2] = "Spanish: Hola al mundo";
    messages[3] = "Klingon: Nuq neH!";
    messages[4] = "German: Guten Tag, Welt!";
    messages[5] = "Russian: Zdravstvytye, mir!";
    messages[6] = "Japan: Sekai e konnichiwa!";
    messages[7] = "Latin: Orbis, te saluto!";

    for(t=0;t<NUM_THREADS;t++) 
    {
        sum = sum + t;
        thread_data_array[t].thread_id = t;
        thread_data_array[t].sum = sum;
        thread_data_array[t].message = messages[t];
        printf("Creating thread %d\n", t);
        if(t==0) osThreadCreate(osThread(t0), (void *)&thread_data_array[t]);
        if(t==1) osThreadCreate(osThread(t1), (void *)&thread_data_array[t]);
        if(t==2) osThreadCreate(osThread(t2), (void *)&thread_data_array[t]);
        if(t==3) osThreadCreate(osThread(t3), (void *)&thread_data_array[t]);
        if(t==4) osThreadCreate(osThread(t4), (void *)&thread_data_array[t]);
        if(t==5) osThreadCreate(osThread(t5), (void *)&thread_data_array[t]);
        if(t==6) osThreadCreate(osThread(t6), (void *)&thread_data_array[t]);
        if(t==7) osThreadCreate(osThread(t7), (void *)&thread_data_array[t]);
    }
}
