#include "CyThread.h"
#include "error.h"
using namespace cnhzcy14;

CyThread::CyThread()
{
//    _tid = -1;
//    _thread_def = NULL;
//    _dynamic_stack = false
    
}

void CyThread::init(void (*task)(void const *argument), void *argument,
        osPriority priority, uint32_t stack_size, unsigned char *stack_pointer) {
#ifdef CMSIS_OS_RTX
    osThreadId _tid;
    _thread_def.pthread = task;
    _thread_def.tpriority = priority;
    _thread_def.stacksize = stack_size;
    if (stack_pointer != NULL) {
        _thread_def.stack_pointer = stack_pointer;
        _dynamic_stack = false;
    } else {
        _thread_def.stack_pointer = new unsigned char[stack_size];
        if (_thread_def.stack_pointer == NULL)
            error("Error allocating the stack memory");
        _dynamic_stack = true;
    }
#endif
    _tid = osThreadCreate(&_thread_def, argument);
}

osStatus CyThread::terminate() {
    return osThreadTerminate(osThreadGetId());
}

osStatus CyThread::set_priority(osPriority priority) {
    return osThreadSetPriority(osThreadGetId(), priority);
}

osPriority CyThread::get_priority() {
    return osThreadGetPriority(osThreadGetId());
}

int32_t CyThread::signal_set(int32_t signals) {
    return osSignalSet(osThreadGetId(), signals);
}

//CyThread::State CyThread::get_state() {
//    return ((State)_thread_def.tcb.state);
//}

osEvent CyThread::signal_wait(int32_t signals, uint32_t millisec) {
    return osSignalWait(signals, millisec);
}

osStatus CyThread::wait(uint32_t millisec) {
    return osDelay(millisec);
}

osStatus CyThread::yield() {
    return osThreadYield();
}

osThreadId CyThread::gettid() {
    return osThreadGetId();
}

CyThread::~CyThread() {
    terminate();
//    if (_dynamic_stack) {
//        delete[] (_thread_def.stack_pointer);
//    }
}

