/*  Copyright 2020 Allan Joshua Veale
 
    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at
 
        http://www.apache.org/licenses/LICENSE-2.0
 
    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

#include "constants.h"

/** Default values for constants
 */

namespace sensors {
    const bool use5kN = false;
    
    // LCM101-100kgf force sensor
    const float kLcm101Offset = -1.5;
    const float kLcm101Factor = 970.55;
    
    // Equation from 7/6/2018 calibration used:
    // kLcm101Offset = 1.99
    // kLcm101Factor = 969.2
    // Equation from 8/3/2019 calibration used:
    // kLcm101Offset = 4.31
    // kLcm101Factor = 1001.1
    
    
    // Gen5kN force sensor
    const float kGen5kNOffset = 0;
    const float kGen5kNFactor = 5530; 
    
    // Equation from 21/2/2019 calibration used:
    // kLcm101Offset = 21.2
    // kLcm101Factor = 5530
      
    
    // Pressure sensor slope and offset values for a gauge pressure reading in bar
    // Equation from 25/6/2018 calibration used:
    const float kSPTE0Offset = -2.33;    
    const float kSPTE0Factor = 12.0;
        
    const float kSPTE1Offset = -2.47;    
    const float kSPTE1Factor = 12.5;   
    
    // Equation from 21/2/2019 calibration used
    // kSPTE0Offset = -2.33
    // kSPTE0Factor = 12.0
        
        
    // AS5048 abs angle sensor chain
    const int kNumJoints = 1;// if hard leg used again - use 4

    const char *kJointNames[]     = {"Knee"};// if hard leg used again - use {"Toes","Ankle","Knee","Hip"}
    const float kOffsetsDegrees[] = {250};// if hard leg used again - use {83.2f,6.3f,170.7f,6.5f}
    const bool kDirections[] = {true};// if hard leg used again - use {false,true,false,true}
}

namespace timing {
    const int TimeControlHertz = 1000;// control loop sample rate
    const int LogDataHertz = 249; //data log sample rate
    const int SerialPrintHertz = 2; //print rate of serial
    
    //corresponding values as a period
    const int kTimeControlUs            =   1000000/TimeControlHertz;   // 1000 Hz control loop
    const int kTimeLogDataUs            =  1000000/LogDataHertz;   //   200 Hz data logging
    const int kTimeSerialPrintUs        = 1000000/SerialPrintHertz;   //    2 Hz serial print
    
    const int minKeyInt                   = 1;                  //minimum key press interval in s. if key is pressed more than once in this time interval it will just register as one press
    const int kSerialBaudrate = 115200; //serial data rate
    
    const int PWMHertz = 10000;//linear actuator PWM frequency
}

namespace rigStructure {
    const bool invertedRig = false; //indicates if rig is inverted or not (for internal torque calculation)
}