/*  Copyright 2020 Allan Joshua Veale
 
    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at
 
        http://www.apache.org/licenses/LICENSE-2.0
 
    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

#ifndef _VALVEDIGITAL_H_
#define _VALVEDIGITAL_H_

#include "mbed.h"
/**
 * Controlling an on/off valve
 */

class ValveDigital
{
public:

    /**
     * @param pin_d_out: PinName of digital output
     */
    ValveDigital (PinName pin_d_out) :
        digital_out_(pin_d_out)
    {
    }

    /**
     * @return valve state
     */
    float getValve()
    {
        return digital_out_.read();
    }

    /**
     * @param set: turn the valve on (true) or off (false)
     */
    void setValve(bool set)
    {
        digital_out_.write((int)set);
        return;
    }


private:
    DigitalOut digital_out_;
};

#endif