#ifndef MBED_XMIT_IR_H
#define MBED_XMIT_IR_H

#include "mbed.h"
#include "rtos.h"

#define ASCII_ETX 0x03
#define ASCII_STX 0x02


class IRTransmitter
{
public:
    IRTransmitter(PinName TX, PinName PWM, PinName RX, int data_buff_len, void (*fptr_isr_rx)(void));
    ~IRTransmitter();
    void MakePacket(char* data,int len);
    char ReadPacket(char* data, int len);
    void isr_rx(char data);
    void set_debug_port(Serial* port);

private:
    char packet_is_valid(int data_len);
    void update_packet_buffer(char new_data, int data_len);

public:
    Mail<char,64> ir_rxdata_mailbox;
    
    Serial* debug_port;

private:
    Serial* ir_serial;
    PwmOut* ir_pwm;
    char*   packet_buffer_out;
    char*   packet_buffer_in;

};








#endif