#include "mbed.h"
#include "MCP23S17.h"

DigitalOut OnOffLED(LED1);
DigitalIn OnOffBtn(p30);
PwmOut PwmLED(LED4);
DigitalIn PwmBtnA(p29);
DigitalIn PwmBtnB(p28);

DigitalOut DebugLEDA(LED2);
DigitalOut DebugLEDB(LED3);

SPI spi(p5, p6, p7);
char Opcode = 0x40;
MCP23S17 chip = MCP23S17(spi, p20, Opcode);



int pwm_btn_val;

int main()
{
    //Init
    OnOffBtn.mode(PullUp);
    PwmBtnA.mode(PullDown);
    PwmBtnB.mode(PullDown);

    //Loop
    while(1) {


        //OnOff LED code
        OnOffLED = !OnOffBtn;

        //PWM example
        if(!PwmBtnA && !PwmBtnB)
            PwmLED = 0.0;
        else if(!PwmBtnA && PwmBtnB)
            PwmLED = 0.33;
        else if(PwmBtnA && !PwmBtnB)
            PwmLED = 0.66;
        else if(PwmBtnA && PwmBtnB)
            PwmLED = 1.0;


        //I/O Expander code
        //  Set all 8 Port A bits to output direction
        chip.direction(PORT_A, 0x00);
        //  Set all 8 Port B bits to input direction
        chip.direction(PORT_B, 0xFF);
        //action
        chip.write(PORT_A, (chip.read(PORT_B)&0x1)?0x80:0x00);
        



    }
}
