#include "mbed.h"
#include "rtos.h"
#include "NokiaLCD.h"
#include "XMIT_IR.h"

#define FPS 5

/****************************************
|=======================================|
|MBED Connections:                      |
|   -p5 : DIO on Sparkfun Nokia LCD     |
|   -p7 : CLK on Sparkfun Nokia LCD     |
|   -p8 : CS  on Sparkfun Nokia LCD     |
|   -p9 : RST on Sparkfun Nokia LCD     |
|   -p21: CTL on Sparkfun IR Xmitter    |
|   -p14: OUT on Sparkfun IR Rcvr       |
|   -p13: GND on Sparkfun IR Xmitter    |
|=======================================|
****************************************/

//Function Prototypes
void BlinkAlive(void const* arguments);
void UpdateLCD(void const* arguments);
void IRStuff(void const* arguments);
void ISR_UARTRX(void);
char CheckPacket(char new_data, char* packet_buffer, char* data, int data_len);
void MakePacket2(char* data,int len);

//Pin Setup
PwmOut led1(LED1);
PwmOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
Serial* devicerx;

//Serial devicetx(p13,NC);
Serial pc(USBTX,USBRX);
PwmOut IRLED_mod(p21);

IRTransmitter ir_tx(p13,p21,p14,4,&ISR_UARTRX); //tx,pwm,size

//Global Vars
char text_buffer[32];
char irdatOUT[10];
char irdatIN[10];
char irdata_out=0;
char error_code=0;
Thread* threadptr_irstuff;
char packet_buff[10];
Mail<char,64> rx_data_mailbox;




int main()
{

    //LCD init
    lcd.background(0x000000);

    //PC serial init
    pc.baud(19200);
    pc.printf("Starting...\n\n");

    //IR_TRX module
    ir_tx.set_debug_port(&pc);


    //Variable Init
    for(int i=0; i<10; i++) packet_buff[i]=0;

    //Threads init
    Thread thread_blinkalive(BlinkAlive);
    Thread thread_updatelcd(UpdateLCD);
    Thread thread_irstuff(IRStuff);
    threadptr_irstuff = &thread_irstuff;



    while(1) {

        //Use main loop to set LCD framerate
        thread_updatelcd.signal_set(0x1);
        Thread::wait(1000/FPS);

    }
}

void UpdateLCD(void const* arguments)
{
    while(true) {

        //Start flash LED
        led2 = 0.02;

        //Write debug text to screen
        lcd.locate(0,1);
        lcd.printf("Debug:");
        lcd.locate(0,3);
        time_t seconds = time(NULL);
        strftime(text_buffer, 32, "%I:%M:%S %p\n", localtime(&seconds));
        lcd.printf("%s", text_buffer);
        lcd.locate(0,4);
        lcd.printf("IR_OUT=0x%02X,0x%02X", irdatOUT[0],irdatOUT[1]);
        lcd.locate(0,5);
        lcd.printf("IR_IN= 0x%02X,0x%02X", irdatIN[0],irdatIN[1]);
        lcd.locate(0,6);
        lcd.printf("Error= 0x%02X", error_code);

        //End - flash LED
        led2 = 0.0;
        //End - Sleep thread
        Thread::signal_wait(0x1);
    }
}

void IRStuff(void const* arguments)
{
    while(true) {

        //If data available - Print data directly to USB port (for debug)
        /*osEvent evt = rx_data_mailbox.get();
        while(evt.status == osEventMail) {
            char* mail = (char*)evt.value.p;
            //if((*mail)==0x02) pc.printf("\n");
            //pc.printf("0x%02X.",*mail);
            error_code = CheckPacket(*mail,packet_buff,irdatIN,4);
            pc.printf("    ERROR=0x%02X.\n",error_code);

            rx_data_mailbox.free(mail);
            evt = rx_data_mailbox.get();
        }*/

        /*osEvent evt = ir_tx.ir_data_mailbox.get();
        while(evt.status == osEventMail) {
            char* mail = (char*)evt.value.p;
            //if((*mail)==0x02) pc.printf("\n");
            //pc.printf("0x%02X.",*mail);
            //error_code = CheckPacket(*mail,packet_buff,irdatIN,4);
            //pc.printf("    ERROR=0x%02X.\n",error_code);

            ir_tx.ir_data_mailbox.free(mail);
            evt = ir_tx.ir_data_mailbox.get();
        }*/

        char result;
        result = ir_tx.ReadPacket(irdatIN,4);
        if(result == 0x1) {
            pc.printf("\n");
            for(int i=0; i<4; i++) {
                pc.printf("0x%02X.",irdatIN[i]);
            }
        }



        //Do not return until we have more data
        //Thread::signal_wait(0x1);
        Thread::wait(10);
    }

}

char CheckPacket(char new_data, char* packet_buffer, char* data, int data_len)
{
    //Requires a packet buffer of length 'data_len'+3.
    //Shifts data and checks each 'set' for a valid packet.
    //Once a valid packet is receievd, the data buffer is updated with new values.
    //returns success(0) or failure(error code)


    char check=0x0;
    //Shift All data 1 cell over
    for(int i=0; i<data_len+2; i++) {
        packet_buffer[i] = packet_buffer[i+1];
    }
    packet_buffer[data_len+2] = new_data;

    //check for valid packet
    if(packet_buffer[0]!=ASCII_STX)
        return 0x1; //bad start byte
    if(packet_buffer[data_len+2]!=ASCII_ETX)
        return 0x2; //bad end byte

    for(int i=1; i<data_len+1; i++) {
        check^=packet_buffer[i];
    }
    if(check!=packet_buffer[data_len+1]) {
        return 0x3; //bad checksum
    }

    return 0;
}

void BlinkAlive(void const* arguments)
{
    while(true) {

        //Change LED1 state (debug)
        (led1==0.0)?led1=0.02:led1=0.0;

        //Form a test packet and send it over IR transmitter
        irdatOUT[0] = 0xA5;
        irdatOUT[1] = ++irdata_out;
        irdatOUT[2] = ~(irdata_out*2);
        irdatOUT[3] = irdata_out*7+13;
        //MakePacket2(irdatOUT,4);
        ir_tx.MakePacket(irdatOUT,4);

        //Roughly use to set rate of data packets per second
        Thread::wait(200);
    }
}

void MakePacket2(char* data,int len)
{
    /*char check =0x0;
    (*devicerx).putc(ASCII_STX);
    for(int i=0; i<len; i++) {
        check^=data[i];
        (*devicerx).putc(data[i]);
    }
    (*devicerx).putc(check);
    (*devicerx).putc(ASCII_ETX);*/
}



//Handle Reception of RX data (mail it to appropriate thread)
void ISR_UARTRX()
{
    //get RX data (and prevent ISR from looping forever
    uint32_t RBR = LPC_UART1->RBR;

    //write letter and put in mailbox
    /*char* mail = rx_data_mailbox.alloc();
    mail[0] = (char)RBR;
    rx_data_mailbox.put(mail);*/

    /*char* mail = ir_tx.ir_data_mailbox.alloc();
    mail[0] = (char)RBR;
    ir_tx.ir_data_mailbox.put(mail);*/

    ir_tx.isr(RBR);

    //Let message handler run
    //(*threadptr_irstuff).signal_set(0x1);

}

