#include "mbed.h"
#include "rtos.h"
#include "NokiaLCD.h"
#include "XMIT_IR.h"
#include "queue.h"

#define FPS 5
#define UART_TIMEOUT 500

/****************************************
|=======================================|
|MBED Connections:                      |
|   -p5 : DIO on Sparkfun Nokia LCD     |
|   -p7 : CLK on Sparkfun Nokia LCD     |
|   -p8 : CS  on Sparkfun Nokia LCD     |
|   -p9 : RST on Sparkfun Nokia LCD     |
|   -p22: GND on Sparkfun IR Xmtr       |
|=======================================|
****************************************/

//Pin Setup
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
Serial device(p13, p14);  // tx, rx
Serial pc(USBTX,USBRX);
PwmOut IRLED_mod(p21);

//Global Vars
char buffer[32];
unsigned char irdata_out=0;
unsigned char irdata_in=0;
char irdatOUT[10];
char irdatIN[10];
char error_code=0;
Thread* threadptr_irstuff;
DataQueue RX_DataBuffer(1,100);
bool rx_data_available = false;
char packet_buff[10];
Mail<char,64> rx_data_mailbox;

//Function Prototypes
void BlinkAlive(void const* arguments);
void UpdateLCD(void const* arguments);
void IRStuff(void const* arguments);
void MakePacket(char* data,int len);
char CheckPacket(char* data, int data_size);
void ISR_UARTRX(void);
void DoNothing(void const* arguments);
char  CheckPacket2(char new_data, char* packet_buffer, char* data, int data_len);


int main()
{

    //LCD init
    lcd.background(0x000000);

    //PWM init
    IRLED_mod.period(1.0/38000.0);  //38kHz Modulation Freq
    IRLED_mod = 0.5;                //pulse width = 50%

    //Serial init
    device.baud(2400);
    device.attach(&ISR_UARTRX,Serial::RxIrq);

    //PC serial init
    pc.baud(19200);
    pc.printf("Starting...\n\n");

    //Variable Init
    for(int i=0; i<10; i++) packet_buff[i]=0;

    //Thread init
    Thread thread_blinkalive(BlinkAlive);
    Thread thread_updatelcd(UpdateLCD);
    Thread thread_irstuff(IRStuff);
    Thread thread_donothing(DoNothing);
    threadptr_irstuff = &thread_irstuff;



    while(1) {
        thread_updatelcd.signal_set(0x1);
        Thread::wait(1000/FPS);

    }
}

void UpdateLCD(void const* arguments)
{
    while(true) {
        led2 = 1;
        lcd.locate(0,1);
        lcd.printf("Debug:");

        lcd.locate(0,3);
        time_t seconds = time(NULL);
        strftime(buffer, 32, "%I:%M:%S %p\n", localtime(&seconds));
        lcd.printf("%s", buffer);

        lcd.locate(0,4);
        lcd.printf("IR_OUT=0x%02X,0x%02X", irdatOUT[0],irdatOUT[1]);
        lcd.locate(0,5);
        lcd.printf("IR_IN= 0x%02X,0x%02X", irdatIN[0],irdatIN[1]);
        lcd.locate(0,6);
        lcd.printf("Error= 0x%02X", error_code);



        //End - Sleep thread
        led2 = 0;
        Thread::signal_wait(0x1);
    }
}

void IRStuff(void const* arguments)
{
    while(true) {
        //error_code = CheckPacket(irdatIN,2);



        //pc.printf("UART_STATE: 0x%08X",*((unsigned int *)0x400FC0C4));

        /*if(rx_data_available) {
            if(irdatIN[0]==0x2) pc.printf("\n");
            pc.printf("0x%02X.",irdatIN[0]);
            //pc.printf("0x%02X.",irdatIN[1]);
            //pc.printf("0x%02X.",irdatIN[2]);
            //pc.printf("0x%02X.\n",irdatIN[3]);
            rx_data_available = false;
        }*/


        /* while(device.readable()) {
             error_code = CheckPacket2(device.getc(), packet_buff, irdatOUT, 2);
             pc.printf("  = 0x%02X.\n",error_code);
         }*/

        osEvent evt = rx_data_mailbox.get();
        while(evt.status == osEventMail) {
            char* mail = (char*)evt.value.p;
            if((*mail)==0x02) pc.printf("\n");
            pc.printf("0x%02X.",*mail);
            rx_data_mailbox.free(mail);
            evt = rx_data_mailbox.get();
        }
        



        //pc.printf("\n\nE=0x%02X\n\n",error_code);
        /*if(error_code==0x0) {
            pc.printf("0x%02X.",irdatIN[1]);
            Thread::wait(10);
        } else if(error_code==0x2) {
            pc.printf("!");
            Thread::wait(10);
        } else {
            Thread::wait(10);
        }*/
        //Thread::signal_wait(0x1);
        Thread::wait(5);
    }

}

void BlinkAlive(void const* arguments)
{
    while(true) {
        led1 = !led1;

        irdatOUT[0] = 0xA5;
        irdatOUT[1] = ++irdata_out;
        MakePacket(irdatOUT,2);
        //pc.printf("UART_STATE: 0x%08X",*((unsigned int *)0x40010014));

        Thread::wait(20);
    }
}

void MakePacket(char* data,int len)
{
    //pc.printf("\nMaking Packet:\n\t");
    char check =0x0;
    device.putc(0x02);
    //pc.printf("0x%02X.",0x02);
    for(int i=0; i<len; i++) {
        check^=data[i];
        device.putc(data[i]);
        //pc.printf("0x%02X.",data[i]);
    }
    device.putc(check);
    //pc.printf("0x%02X.",check);
    //pc.printf("\nDone making packet.\n");
}

char  CheckPacket(char* data, int data_size)
//returns success(0) or failure(error code)
{
    Timer t;
    t.reset();
    t.start();
    char tempdata=0x0;
    char check=0x0;

    //pc.printf("\nChecking Packet\n\t");
    //Data available
    if(!device.readable()) {
        //pc.printf("no data");
        return 0x4; //no data
    }

    while(!device.readable());
    //while(!device.readable() && t.read_ms()<=UART_TIMEOUT);
    //if(t.read_ms()>=UART_TIMEOUT)
    //    return 0x3; //timeout error
    tempdata = device.getc();

    //STX recieved
    if(tempdata!=0x02) {
        if(tempdata==0xFF) pc.printf("found bad data: 0x%02X",tempdata);
        pc.printf("UART_STATE: 0x%08X",*((unsigned int *)0x40010014));
        return 0x1; //bad start byte
    }

    //Get Data
    for(int i=0; i<data_size; i++) {
        while(!device.readable());
        //while(!device.readable() && t.read_ms()<=UART_TIMEOUT);
        //if(t.read_ms()>=UART_TIMEOUT)
        //    return 0x3; //timeout error
        data[i] = device.getc();
        check += data[i];
    }
    //Get Checksum
    while(!device.readable());
    //while(!device.readable() && t.read_ms()<=UART_TIMEOUT);
    //if(t.read_ms()>=UART_TIMEOUT)
    //    return 0x3; //timeout error
    tempdata = device.getc();
    if(tempdata!=check)
        return 0x2; //bad checksum


    return 0;

}

char  CheckPacket2(char new_data, char* packet_buffer, char* data, int data_len)
//returns success(0) or failure(error code)
{
    //Requires a packet buffer of length 'data_len'+2.
    //Shifts data and checks each 'set' for a valid packet.
    //Once a valid packet is receievd, the data buffer is updated with new values.

    char check=0x0;
    pc.printf("Shifting: ");
    //Shift All data 1 cell over
    for(int i=0; i<data_len+1; i++) {
        packet_buffer[i] = packet_buffer[i+1];
    }
    packet_buffer[data_len+1] = new_data;
    for(int i=0; i<data_len+2; i++) {
        pc.printf("0x%02X.",packet_buffer[i]);
    }

    //check for valid packet
    if(packet_buffer[0]!=0x02)
        return 0x1; //bad start byte

    for(int i=1; i<data_len+1; i++) {
        check^=packet_buffer[i];
    }
    if(check==packet_buffer[data_len+1]) {
        return 0;
    }
    return 0;
}

void DoNothing(void const* arguments)
{
    while(true) {
        Thread::signal_wait(0x1);
    }
}

void ISR_UARTRX(void)
{
    uint32_t RBR = LPC_UART1->RBR;


    //irdatIN[0] = (char)RBR;

    char* mail = rx_data_mailbox.alloc();
    mail[0] = (char)RBR;
    rx_data_mailbox.put(mail);

    /*if(device.readable())
        irdatIN[1] = (char) LPC_UART1->RBR;
    if(device.readable())
        irdatIN[2] = (char) LPC_UART1->RBR;
    if(device.readable())
        irdatIN[3] = (char) LPC_UART1->RBR;
        */

    rx_data_available = true;
    (*threadptr_irstuff).signal_set(0x1);


    /*while(device.readable()) {
        char data = device.getc();
        //pc.printf("*");
    }*/

}

