/*TAREA DOS: Aumento con gradientes de los parámetros Sp, Kp, Ki y Kd de un Control PID simple.
  Con tarjeta FREESCALE KL25Z*/

#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
 
AnalogIn Vin(PTC2);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DebouncedIn button1(PTC12);     // Aumento
DebouncedIn button2(PTC13);     // Disminución
DebouncedIn button3(PTC16);     // Cambio de variable
DebouncedIn button4(PTC17);     // Reset
 
int C1=0x0E;                                                // solo muestra el curzor.
int C2=0x18;                                                // desplaza izquierda.
int C3=0x1A;                                                // desplaza derecha.
int C4=0x0C;                                                // quito cursor bajo.
 
int i;                                                      // Indice de la variable.
int j;                                                      // Controla cambio de posición.
int kp, ki, kd, sp, cont; 
 
int main(){
    lcd.writeCommand(C1);                                   // Escribimos un comando segun el manual del modulo LCD
    lcd.cls();                                               // Borro toda la pantalla
    lcd.locate(0,0);                                         // Localizo donde se escribirá el siguiente comando.    
    lcd.printf("Sp %d",sp);                                  // Escribe Sp (aparecen desde el punto (0,0)
    lcd.locate(8,0);                                         // Localizo donde se escribirá el siguiente comando.
    lcd.printf("Kp %d",kp);                                  // Escribe Kp (aparecen desde el punto (8,0)
    lcd.locate(0,1);
    lcd.printf("Ki %d",ki);
    lcd.locate(8,1);
    lcd.printf("Kd %d",kd);
  
        
    while(1){
           led3 =1;
           if (button3.falling()){
              led3 =!led3;                                // Prendo el LED color rojo cada vez que pulso el boton 3 ya que pasa a valer 0 (encendido).              
               ++j;
                                 }                        // INCREMENTA POSICION DEL MENU CON BOTON 3
           if (j==0){
               lcd.locate(3,0);
               lcd.printf("%d",sp);
                              
               wait(0.2);
                  
               led1 = 1;
               
               if(button1.falling()) { 
               led1 =!led1;                            // Prendo el LED color azul cada vez que pulso el boton 1 ya que pasa a valer 0 (encendido).        
               //++sp;                                 // Incrementa valor al pulsar el botón --> Ahora no lo usamos acá ya que necesitamos incremental.
               
               
               // Ahora comienza el incremental.               
               
                  if (!button1) {  
                  cont=0;
                  wait(0.2);
               
                     while(cont<20){ 
                     cont = cont + 1;   
                     sp=sp+1; 
                     if (sp>1000){                     // Ponemos un tope incremental en 10.000
                     sp=1000;
                               }       
                     lcd.locate(0,0); 
                     lcd.printf("Sp %d",sp); 
                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }              
                     while(cont>=20){ 
                     cont=cont+1;   
                     sp=sp+10;
                     if (sp>1000){                     // Ponemos un tope incremental en 10.000
                     sp=1000;
                               }  
                     lcd.locate(0,0); 
                     lcd.printf("Sp %d",sp); 
                                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }
                                
                     while(cont>40){ 
                     cont = cont + 1;   
                     sp=sp+100;
                     if (sp>1000){                     // Ponemos un tope incremental en 10.000
                     sp=1000;
                               }  
                     lcd.locate(0,0); 
                     lcd.printf("Sp %d",sp); 
                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }                                
                            }    
                            }
                            }
                            }
                            
        // Aqui termina el incremental.
                                      }
 
                                         
                  led2 =1;
                  if (button2.falling()) {  
                  led2 =!led2;                            // Prendo el LED color rojo cada vez que pulso el boton 2 ya que pasa a valer 0 (encendido).       
                  
                  //--sp;                                   // Reduce el valor al pulsar el botón.
                                         } 
                  
                                  
                  // Ahora comienza el decremental.               
               
                  if (!button2) {  
                  cont=0;
                  wait(0.2);
               
                     while(cont<20){ 
                     cont = cont + 1;   
                     sp=sp-1; 
                     
                     lcd.locate(3,0);
                     lcd.printf("         ");
                     lcd.locate(0,0);
                     lcd.printf("Sp %d",sp);
                     
                     if (sp<0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     sp=0;
                              }
                                          
                                                               
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }              
                      
                     while(cont>=20){ 
                     cont=cont+1;   
                     sp=sp-10; 
                     if (sp<0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     sp=0;
                                                   }
                     
                     lcd.locate(0,0); 
                     lcd.printf("Sp %d ",sp); 
                     
                                     
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }
                                
                     while(cont>40){ 
                     cont = cont + 1;   
                     sp=sp-100; 
                     
                     if (sp<0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     sp=0;
                              }
                     
                     lcd.locate(0,0); 
                     lcd.printf("Sp %d ",sp); 
                     
                     
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }                                
                            }    
                            }
                            }
                            }
                            
        // Aqui termina el decremental.
                  
                  
                  
                  
                  
                  
                           
                    }
           if (j==1){
               lcd.locate(11,0);
               lcd.printf("%d",kp);
               wait(0.3);
                  led1 =1;
                  if (button1.falling()) {
                    led1 =!led1;
                    ++kp;
                                         }
                  led2 =1;
                  if (button2.falling()) {  
                    lcd.locate(11,0);
                    lcd.printf("%d   ");
                    led2 =!led2;                          
                    --kp;
                                         }
                 if (kp>10000){
                    kp=10000;
                    lcd.locate(11,0);
                    lcd.printf("%d",kp);
                              } 
                                         
                 if (kp<0){
                    kp=0;
                    lcd.locate(11,0);
                    lcd.printf("%d",kp);
                          }   
                    }
           if (j==2){
               lcd.locate(3,1);
               lcd.printf("%d",ki);
               wait(0.3);
                  led1 =1;
                  if (button1.falling()){
                    led1 =!led1;
                    ++ki;
                                        }
                  led2 =1;
                  if (button2.falling()){
                    lcd.locate(3,1);
                    lcd.printf("%d   ");                    
                    led2 =!led2;                          
                    --ki;
                                        }   
                  if (ki>10000){
                    ki=10000;
                    lcd.locate(3,1);
                    lcd.printf("%d",ki);
                               } 
                                         
                  if (ki<0){
                    ki=0;
                    lcd.locate(3,1);
                    lcd.printf("%d",ki);
                           }
                    }   
           
           if (j==3){
               lcd.locate(11,1);
               lcd.printf("%d",kd);
               wait(0.3);
                  led1 =1;
                  if (button1.falling()){
                  led1 =!led1;
                  ++kd;
                                        }
                  led2 =1;
                  if (button2.falling()){
                    lcd.locate(11,1);
                    lcd.printf("%d   ");
                    led2 =!led2;                            
                    --kd;
 
                    
                                        }
                  if (kd>10000){
                    kd=10000;
                    lcd.locate(11,1);
                    lcd.printf("%d",kd);
                               } 
                                         
                  if (kd<0){
                    kd=0;
                    lcd.locate(11,1);
                    lcd.printf("%d",kd);
                           }   
                    } 
           
                  if (j==4){
                    j=0;
                           }                          
    
                 if (button4.falling()){
                    sp=0;
                    kp=0;
                    ki=0;
                    kd=0;
                    lcd.locate(11,1);
                    lcd.printf("%d   ",kd);
                    lcd.locate(3,1);
                    lcd.printf("%d   ",ki);
                    lcd.locate(11,0);
                    lcd.printf("%d   ",kp);
                    lcd.locate(3,0);
                    lcd.printf("%d   ",sp);
                                       }     
            }           
          }
            
