/* Parámetros del Control: Caracterización:
                           Cabecera baja = 8930us
                           Cabecera alta = 4430us
                           Uno lógico    = 1600us
                           Cero Lógico   =  533us
                       tiempo entre bits =  633us                                */

#include "mbed.h"     //LLamado de librerías.
#include <Pulse1.h>

PulseInOut irda(PTD5);// en este puerto se pone el sensor infrarrojo
Serial pc(USBTX, USBRX);
DigitalOut a0(LED1); // Se establecen las salidas para los leds 1, 2 y 3 de la tarjeta KL25Z
DigitalOut a1(LED2);
DigitalOut a2(LED3);
int header =0; //tiempo de cabecera pulso abajo
const int head_H = 10716; //+20% medida con osciloscopio en [microsegundos]   (Cabecera)
const int head_L = 7144;//-20%  medida con osciloscopio en [microsegundos] 
int i=0; //Se define una Variable tipo int.
const int T_alto=1600;//ponga su tiempo de la prueba (tiempo de uno lógico)
const int T_bajo=533;//ponga su tiempo de la prueba  (tiempo cero lógico)
const int num_bits = 33;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int dato; // tiempo de cada dato que se lee
int b1[32],b2[32],b3[32]; //Se crean tres vectores que contendran la cadena de bits de tres botones del  control remoto 
  
int main(){
    //Luego se saber la cadena de bits de los botones [1],[2] y [3] del control remoto, se meten a los vectores b1, b2 y b3 respectivamente.
    b1[0]=b1[1]=b1[2]=b1[3]=b1[4]=b1[5]=b1[6]=b1[7]=b1[16]=b1[17]=b1[20]=b1[21]=b1[22]=b1[23]=b1[26]=b1[27]=0;
    b1[8] =b1[9]=b1[10]=b1[11]=b1[12]=b1[13]=b1[14]=b1[15]=b1[18]=b1[19]=b1[24]=b1[25]=b1[28]=b1[29]=b1[30]=b1[31]=1;
    
    b2[0]=b2[1]=b2[2]=b2[3]=b2[4]=b2[5]=b2[6]=b2[7]=b2[16]=b2[17] =b2[18] =b2[21]=b2[22]=b2[23] =b2[27] =b2[28]=0;
    b2[8] =b2[9]=b2[10]=b2[11]=b2[12]=b2[13]=b2[14]=b2[15] =b2[19] =b2[20]=b2[24]=b2[25] =b2[26] =b2[29]=b2[30]=b2[31]=1;
    
    b3[0]=b3[1]=b3[2]=b3[3]=b3[4]=b3[5]=b3[6]=b3[7]=b3[16] =b3[21]= b3[23] =b3[27] =b3[25] =b3[26]=b3[28] =b3[30]=0;
    b3[8] =b3[9]=b3[10]=b3[11]=b3[12]=b3[13]=b3[14]=b3[15] =b3[17] =b3[18]=b3[19] =b3[20]= b3[22]=b3[24] =b3[29] =b3[31]=1;
 

    int m,e,r; //defino variables para la activación de cada botón delcontrol remoto
    m=e=r=0;
    a0=a1=a2=1;
while(1){
      ini1: header=0;
      header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
      if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
      else goto ini1;
      
seguir:
       //leo los datos de la trama y se meten a un arreglo
      wait_us(400);
      
      for(i=0;i<(num_bits-1);++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
            dato = irda.read_high_us(); //leer un bit de datos que es pulso arriba en este control
            num[i]=dato;
            wait_us(400);   
        }
      
      wait(0.8); //   (0.5)Espero 
      
      
       for(i=0;i<(num_bits-1);++i){  
            if(num[i] > ((T_alto+T_bajo)/2)) num[i]=1;
            else num[i]=0;
        }
        for(i=0;i<(num_bits-1);++i){
            if(num[i]==b1[i])m++;
        }
 
        if(m==32){
            a0=!a0;
        }
        for(i=0;i<(num_bits-1);++i){
            if(num[i]==b2[i])e++;
        }
 
        if(e==32){
            a1=!a1;
        }
        for(i=0;i<(num_bits-1);++i){
            if(num[i]==b3[i])r++;
        }
 
        if(r==32){
            a2=!a2;
        }
        m=e=r=0;
      }
}
