#include <easyvr.h>

EasyVR::EasyVR( PinName tx, PinName rx ) : dev( tx, rx )
{
    // Nothing
}

void EasyVR::wakeup()
{
    do
    {
        send( CMD_BREAK );
        wait( 0.2 );
    } while( receive() != STS_SUCCESS );
}

void EasyVR::setup( int lang, int timeout )
{
    char err;
    
    send( CMD_ID );
    
    if( ( err = receive() ) != STS_ID )
        term.printf( "(in setup() line %d) Error: %c\r\n", __LINE__, err );
    
    send( ARG_ACK );
    
    switch( a2i( err = receive() ) )
    {
        case 0:
            term.printf( "VRbot detected\r\n" );
            break;
        case 1:
            term.printf( "EasyVR detected\r\n" );
            break;
        default:
            term.printf( "(in setup() line %d) Error: %c\r\n", __LINE__, err );
            break;
    }
    
    send( CMD_LANGUAGE );
    send( i2a( lang ) );
    
    if( ( err = receive() ) != STS_SUCCESS )
        term.printf( "(in setup() line %d) Error: %c\r\n", __LINE__, err );
    
    send( CMD_TIMEOUT );
    send( i2a( timeout ) );
    
    if( ( err = receive() ) != STS_SUCCESS )
        term.printf( "(in setup() line %d) Error: %c\r\n", __LINE__, err );
}

void EasyVR::send( char byte )
{
    dev.putc( byte );
}

char EasyVR::receive()
{
    return dev.getc();
}

void EasyVR::baud( int rate )
{
    dev.baud( rate );
}
