/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * File: AEB0.c
 *
 * Code generated for Simulink model 'AEB0'.
 *
 * Model version                  : 1.77
 * Simulink Coder version         : 8.10 (R2016a) 10-Feb-2016
 * C/C++ source code generated on : Thu Jul 28 19:46:51 2016
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Intel->x86-64 (Windows64)
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "AEB0.h"
#include "AEB0_private.h"

/* Named constants for Chart: '<Root>/AEB ' */
#define AEB0_IN_AEB_misbehaviour       ((uint8_T)1U)
#define AEB0_IN_AEB_ok                 ((uint8_T)2U)
#define AEB0_IN_NO_ACTIVE_CHILD        ((uint8_T)0U)
#define AEB0_IN_brake_fault            ((uint8_T)1U)
#define AEB0_IN_brake_off_             ((uint8_T)1U)
#define AEB0_IN_brake_on_              ((uint8_T)2U)
#define AEB0_IN_ok                     ((uint8_T)1U)
#define AEB0_IN_ok2                    ((uint8_T)3U)
#define AEB0_IN_zero_dist              ((uint8_T)2U)
#define AEB0_IN_zero_dist_fault        ((uint8_T)3U)
#define AEB0_div                       (100.0)

/* Block states (auto storage) */
DW_AEB0_T AEB0_DW;

/* External inputs (root inport signals with auto storage) */
ExtU_AEB0_T AEB0_U;

/* External outputs (root outports fed by signals with auto storage) */
ExtY_AEB0_T AEB0_Y;

/* Real-time model */
RT_MODEL_AEB0_T AEB0_M_;
RT_MODEL_AEB0_T *const AEB0_M = &AEB0_M_;

/* Model step function */
void AEB0_step(void)
{
  /* Chart: '<Root>/AEB ' incorporates:
   *  Inport: '<Root>/distance_m'
   *  Inport: '<Root>/speed_km_h'
   */
  if (AEB0_DW.temporalCounter_i1 < 7U) {
    AEB0_DW.temporalCounter_i1++;
  }

  if (AEB0_DW.temporalCounter_i2 < 7U) {
    AEB0_DW.temporalCounter_i2++;
  }

  /* Gateway: AEB
   */
  /* During: AEB
   */
  if (AEB0_DW.is_active_c3_AEB0 == 0U) {
    /* Entry: AEB
     */
    AEB0_DW.is_active_c3_AEB0 = 1U;

    /* Entry Internal: AEB
     */
    /* Transition: '<S1>:37' */
    AEB0_DW.is_AEB_distance_sensor_fault_de = AEB0_IN_ok;

    /* Outport: '<Root>/fault' */
    /* Entry 'ok': '<S1>:21' */
    /* '<S1>:21:1' fault=0 */
    AEB0_Y.fault = 0.0;

    /* Entry Internal 'AEB_brake_fault_detection': '<S1>:41' */
    /* Transition: '<S1>:44' */
    AEB0_DW.is_AEB_brake_fault_detection = AEB0_IN_ok2;

    /* Entry Internal 'AEB_ALGO': '<S1>:40' */
    /* Transition: '<S1>:4' */
    AEB0_DW.is_AEB_ALGO = AEB0_IN_AEB_ok;
    AEB0_DW.is_AEB_ok = AEB0_IN_brake_off_;

    /* Outport: '<Root>/brake' */
    /* Entry 'brake_off_': '<S1>:3' */
    /* '<S1>:3:1' brake=0 */
    AEB0_Y.brake = 0.0;
  } else {
    /* During 'AEB': '<S1>:39' */
    /* During 'AEB_fault_detection': '<S1>:43' */
    /* During 'AEB_distance_sensor_fault_detection': '<S1>:42' */
    switch (AEB0_DW.is_AEB_distance_sensor_fault_de) {
     case AEB0_IN_ok:
      /* During 'ok': '<S1>:21' */
      /* '<S1>:23:1' sf_internal_predicateOutput = ... */
      /* '<S1>:23:1' distance_m == 0; */
      if (AEB0_U.distance_m == 0.0) {
        /* Transition: '<S1>:23' */
        AEB0_DW.is_AEB_distance_sensor_fault_de = AEB0_IN_zero_dist;
        AEB0_DW.temporalCounter_i1 = 0U;
      }
      break;

     case AEB0_IN_zero_dist:
      /* During 'zero_dist': '<S1>:28' */
      /* '<S1>:24:1' sf_internal_predicateOutput = ... */
      /* '<S1>:24:1' distance_m > 0; */
      if (AEB0_U.distance_m > 0.0) {
        /* Transition: '<S1>:24' */
        AEB0_DW.is_AEB_distance_sensor_fault_de = AEB0_IN_ok;

        /* Outport: '<Root>/fault' */
        /* Entry 'ok': '<S1>:21' */
        /* '<S1>:21:1' fault=0 */
        AEB0_Y.fault = 0.0;
      } else {
        /* '<S1>:26:1' sf_internal_predicateOutput = ... */
        /* '<S1>:26:1' after(500, msec); */
        if (AEB0_DW.temporalCounter_i1 >= 5U) {
          /* Transition: '<S1>:26' */
          AEB0_DW.is_AEB_distance_sensor_fault_de = AEB0_IN_zero_dist_fault;

          /* Outport: '<Root>/fault' */
          /* Entry 'zero_dist_fault': '<S1>:25' */
          /* '<S1>:25:1' fault=1 */
          AEB0_Y.fault = 1.0;
        }
      }
      break;

     default:
      /* During 'zero_dist_fault': '<S1>:25' */
      break;
    }

    /* During 'AEB_brake_fault_detection': '<S1>:41' */
    switch (AEB0_DW.is_AEB_brake_fault_detection) {
     case AEB0_IN_brake_fault:
      /* During 'brake_fault': '<S1>:34' */
      break;

     case AEB0_IN_brake_on_:
      /* During 'brake_on_': '<S1>:32' */
      /* '<S1>:35:1' sf_internal_predicateOutput = ... */
      /* '<S1>:35:1' (after(500, msec)) && (speed_km_h>=speed_at_brake_start &&  speed_km_h > 0 && brake>0.1); */
      if ((AEB0_DW.temporalCounter_i2 >= 5U) && (AEB0_U.speed_km_h >=
           AEB0_DW.speed_at_brake_start) && (AEB0_U.speed_km_h > 0.0) &&
          (AEB0_Y.brake > 0.1)) {
        /* Transition: '<S1>:35' */
        AEB0_DW.is_AEB_brake_fault_detection = AEB0_IN_brake_fault;

        /* Outport: '<Root>/fault' */
        /* Entry 'brake_fault': '<S1>:34' */
        /* '<S1>:34:1' fault=1 */
        AEB0_Y.fault = 1.0;
      } else {
        /* '<S1>:46:1' sf_internal_predicateOutput = ... */
        /* '<S1>:46:1' (after(500, msec)) && (speed_km_h<speed_at_brake_start); */
        if ((AEB0_DW.temporalCounter_i2 >= 5U) && (AEB0_U.speed_km_h <
             AEB0_DW.speed_at_brake_start)) {
          /* Transition: '<S1>:46' */
          AEB0_DW.is_AEB_brake_fault_detection = AEB0_IN_brake_on_;
          AEB0_DW.temporalCounter_i2 = 0U;

          /* Entry 'brake_on_': '<S1>:32' */
          /* '<S1>:32:1' speed_at_brake_start = speed_km_h */
          AEB0_DW.speed_at_brake_start = AEB0_U.speed_km_h;
        } else {
          /* '<S1>:47:1' sf_internal_predicateOutput = ... */
          /* '<S1>:47:1' brake==0; */
          if (AEB0_Y.brake == 0.0) {
            /* Transition: '<S1>:47' */
            AEB0_DW.is_AEB_brake_fault_detection = AEB0_IN_ok2;
          }
        }
      }
      break;

     default:
      /* During 'ok2': '<S1>:31' */
      /* '<S1>:33:1' sf_internal_predicateOutput = ... */
      /* '<S1>:33:1' brake==1; */
      if (AEB0_Y.brake == 1.0) {
        /* Transition: '<S1>:33' */
        AEB0_DW.is_AEB_brake_fault_detection = AEB0_IN_brake_on_;
        AEB0_DW.temporalCounter_i2 = 0U;

        /* Entry 'brake_on_': '<S1>:32' */
        /* '<S1>:32:1' speed_at_brake_start = speed_km_h */
        AEB0_DW.speed_at_brake_start = AEB0_U.speed_km_h;
      }
      break;
    }

    /* During 'AEB_ALGO': '<S1>:40' */
    if (AEB0_DW.is_AEB_ALGO != AEB0_IN_AEB_misbehaviour) {
      /* During 'AEB_ok': '<S1>:14' */
      /* '<S1>:16:1' sf_internal_predicateOutput = ... */
      /* '<S1>:16:1' fault==1; */
      if (AEB0_Y.fault == 1.0) {
        /* Transition: '<S1>:16' */
        /* Exit Internal 'AEB_ok': '<S1>:14' */
        AEB0_DW.is_AEB_ok = AEB0_IN_NO_ACTIVE_CHILD;
        AEB0_DW.is_AEB_ALGO = AEB0_IN_AEB_misbehaviour;

        /* Outport: '<Root>/brake' */
        /* Entry 'AEB_misbehaviour': '<S1>:15' */
        /* '<S1>:15:1' brake=0 */
        AEB0_Y.brake = 0.0;
      } else if (AEB0_DW.is_AEB_ok == AEB0_IN_brake_off_) {
        /* During 'brake_off_': '<S1>:3' */
        /* '<S1>:5:1' sf_internal_predicateOutput = ... */
        /* '<S1>:5:1' speed_km_h^2/div>distance_m; */
        if (AEB0_U.speed_km_h * AEB0_U.speed_km_h / AEB0_div > AEB0_U.distance_m)
        {
          /* Transition: '<S1>:5' */
          AEB0_DW.is_AEB_ok = AEB0_IN_brake_on_;

          /* Outport: '<Root>/brake' */
          /* Entry 'brake_on_': '<S1>:1' */
          /*  brake is proportional to the inverse of distance */
          /*  and to the speed. This was required */
          /*  since it was requested that the led frequency */
          /*  must be proportional to the brake request */
          /* '<S1>:1:3' brake=1 */
          AEB0_Y.brake = 1.0;
        }
      } else {
        /* During 'brake_on_': '<S1>:1' */
        /* '<S1>:6:1' sf_internal_predicateOutput = ... */
        /* '<S1>:6:1' speed_km_h^2/div<distance_m; */
        if (AEB0_U.speed_km_h * AEB0_U.speed_km_h / AEB0_div < AEB0_U.distance_m)
        {
          /* Transition: '<S1>:6' */
          AEB0_DW.is_AEB_ok = AEB0_IN_brake_off_;

          /* Outport: '<Root>/brake' */
          /* Entry 'brake_off_': '<S1>:3' */
          /* '<S1>:3:1' brake=0 */
          AEB0_Y.brake = 0.0;
        }
      }
    } else {
      /* During 'AEB_misbehaviour': '<S1>:15' */
    }
  }

  /* End of Chart: '<Root>/AEB ' */
}

/* Model initialize function */
void AEB0_initialize(void)
{
  /* Registration code */

  /* initialize error status */
  rtmSetErrorStatus(AEB0_M, (NULL));

  /* states (dwork) */
  (void) memset((void *)&AEB0_DW, 0,
                sizeof(DW_AEB0_T));

  /* external inputs */
  (void) memset((void *)&AEB0_U, 0,
                sizeof(ExtU_AEB0_T));

  /* external outputs */
  (void) memset((void *)&AEB0_Y, 0,
                sizeof(ExtY_AEB0_T));

  /* SystemInitialize for Chart: '<Root>/AEB ' */
  AEB0_DW.is_AEB_ALGO = AEB0_IN_NO_ACTIVE_CHILD;
  AEB0_DW.is_AEB_ok = AEB0_IN_NO_ACTIVE_CHILD;
  AEB0_DW.is_AEB_brake_fault_detection = AEB0_IN_NO_ACTIVE_CHILD;
  AEB0_DW.temporalCounter_i2 = 0U;
  AEB0_DW.is_AEB_distance_sensor_fault_de = AEB0_IN_NO_ACTIVE_CHILD;
  AEB0_DW.temporalCounter_i1 = 0U;
  AEB0_DW.is_active_c3_AEB0 = 0U;

  /* SystemInitialize for Outport: '<Root>/fault' incorporates:
   *  SystemInitialize for Chart: '<Root>/AEB '
   */
  AEB0_Y.fault = 0.0;
}

/* Model terminate function */
void AEB0_terminate(void)
{
  /* (no terminate code required) */
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
