#include "BBSerial.h"

#include "stdio.h"

BBSerial::BBSerial() :
uart(PTC17, PTC16) // tx, rx of uart3
{
    uart.baud(9600);
    uart.format(8, SerialBase::Odd, 2);
}


void BBSerial::printf(const char* format, ...) {
    va_list argptr;
    va_start(argptr, format);
    
    char newFormat[200];
    
    // Add garbage and header in order to resolve first byte error
    sprintf(newFormat, "GARBAGEAAAAA%sZZZZZ\n", format);
    char buf[200];
    vsprintf(buf, newFormat, argptr);
    uart.printf("%s", buf);
 
    va_end(argptr);   
}

int BBSerial::scanf(const char* format, ...) {
    if(!uart.readable()) {
        return 0;
    }
    va_list argptr;
    va_start(argptr, format);
    
    char line[200];
    uart.gets(line, 200);
    line[199] = '\0';
    
    int read=0;
    
    int start = 0;
    for (int i = 0; i < 10; i++) {
        if(strncmp("AAAAA", &line[i], 5) == 0) {
            start = i+5;
        }
    }
    char *clean = &line[start];
    
    int end = strlen(clean)-6;
    clean[end] = 0;
    
    if(start < 1) {
        read = 0;
    } else {
        read = vsscanf(clean, format, argptr);
    }
      
    va_end(argptr);   
    return read;
}