#include <mbed.h>

extern Serial pc;

void serialSend(float v) {
    pc.printf("aaaa"); // header
    unsigned char* data = (unsigned char*) &v;
    for (int i = 0; i < 4; i++) {
      pc.putc(data[i]);
    }
    pc.printf("\r\n"); // end of line
}

void serialSendVec(float vec[], int length) {
    pc.printf("aaaa"); // header
    unsigned char* data = (unsigned char*) vec;
    for (int i = 0; i < length*4; i++) {
      pc.putc(data[i]);
    }
    pc.printf("\r\n"); // end of line

}

enum RecvState {
    NONE,
    HEADER, 
    DATA, 
    END
};

float serialRecv() {
    RecvState state = NONE;
    int headerStep = 0;
    int dataStep = 0;
    bool receiving = 1;
    char buf[8];
    float v = -10;
    while(receiving) {
        char c = pc.getc();
        switch(state) {
            case NONE:
            case HEADER:
                if(c == 'a') {
                    headerStep++;
                    if(headerStep == 4) {
                        state = DATA;
                        dataStep = 0;
                        v = 0;
                    }
                } else {
                    headerStep = 0;
                }
                break;
            case DATA:
                dataStep += 1;
                buf[dataStep-1] = c;
                if(dataStep == 4) {
                  state = END;
                  v = *(float*)buf;
                }
                break;
            case END: 
                if(c == '\r' && pc.getc() == '\n') {
                  return v;
                } else {
                  state = NONE;
                  headerStep = 0;
                }
                break;
        }
    }
    return v;
}
