#include "mbed.h"
#include "TextLCD.h"

PwmOut motor(p21);   //Control the speed of the fan 
DigitalInOut DHT11(p5); // Activate digital in as dht11 Pin
TextLCD lcd(p6, p7, p14, p15, p16, p17); // rs, e, d4-d7


Timer tmr; //initialize timer
uint64_t adat; // 64 bit variable for temporary data
int i;
void dht_read(void) {
    DHT11.output(); // Set p5 as output
    // Initialize measurement > 18 ms low
    DHT11 = 0;
    wait_ms(20);
    // After high and release the pin switch input mode
    DHT11 = 1;
    DHT11.input();
    // Wait until the end of 80 us low
    while(!DHT11.read()) {}
    // Wait until end of 80 us high
    while(DHT11.read()) {}
    // 40 bit, 40 read out cycle
    for(i=0; i<40; i++) {
        adat = adat << 1; // Shift for new number
        tmr.stop(); // Stop timer if runs
        tmr.reset();  // Reset timer
        // Wait until pin
        while(!DHT11.read()) {}          
        tmr.start();            
        while(DHT11.read()) {}
        // If DHT11 HIGH longer than 40 micro seconds (hopefully 70 us)
        if(tmr.read_us() > 40) {
            // bit is 1
            adat++;
        }
    }
}

int main() {
    while(1) {
            adat = 0;
            motor.period(0.010);
            dht_read(); // Call the function   
            int tem = (adat & 0x0000000000ff0000) >> 16;            
            lcd.printf("Temperature:");
            lcd.printf("%d\n",tem);     // Temperature       
            if(tem <= 20){
                motor = 0; 
                lcd.locate(4,1);
                lcd.printf("Fan OFF");
            }
            else if(tem > 20 && tem <= 22) {
                motor = 0.2;   
                lcd.printf("Fan Speed:");
                lcd.locate(12,1);  
                lcd.printf("20%");
            }
            else if(tem > 22 && tem <= 24) {
                motor = 0.4;
                lcd.printf("Fan Speed:");
                lcd.locate(12,1);  
                lcd.printf("40%");                  
            }
            else if(tem > 24 && tem <= 26) {
                motor = 0.6;
                lcd.printf("Fan Speed:");
                lcd.locate(12,1);  
                lcd.printf("60%");    
            }
            else if(tem > 26 && tem <= 28) {
                motor = 0.8;
                lcd.printf("Fan Speed:");
                lcd.locate(12,1);  
                lcd.printf("80%");    
            }
            else {
                motor = 1;
                lcd.printf("Fan Speed:");
                lcd.locate(12,1);  
                lcd.printf("100%");   
            }
            wait(2); // Wait 2 sec till continue.
            lcd.cls(); // Clear the screen
    }
}