#include "mbed.h"
#include "DHT.h"
#include "hcsr04.h"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "MbedJSONValue.h"
#include <string>

//### Declaracao do sensor de movimento
InterruptIn motion(PTC2);
int motion_detected = 0;
void irq_handler(void)
{
    motion_detected = 1;
}

//### Declaracao do sensor de distancia
HCSR04 usensor(PTA0, PTC3); //usensor(TRIGGER, ECHO)
unsigned int dist;

//### Inicio do programa
int main() {
    //### Inicio da interface de rede
    EthernetInterface eth;
    //### Declaracao do LED para indicar conexao de WS
    DigitalOut ledON(PTA2);
    //### Declaracao do LED para indicar erro de conexao de WS
    DigitalOut ledOFF(PTB23);
    //### Declaracao do SERVO que ira liberar alimento
    DigitalOut servo(PTC10);
    //### Declaracao de sensor de temperatura
    DHT sensor(PTA1,SEN11301P);
    //### Inicializacao do sensor de movimento
    motion.rise(&irq_handler);
    //### Declaracao do buzzer
    DigitalOut buzzer(PTC16);
    
    //### Variavel para armazener sinal de erro
    int err;
    
    printf("Inciando programa Pet-iot-ws\r\n");
    //### Iniciar inteface de rede
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP adquirido %s\n\r", eth.getIPAddress());
    
    //### Tenta se conectar ao socket server
    printf("Inciando conexao com o servidor Websocket\r\n");
    Websocket ws("ws://192.168.100.115:3000/ws/freescale");
    
    if(ws.connect()){
        //### Variavel para armazenar as mensagems JSON
        MbedJSONValue mensagemJSON;
        //### Variavel para os parses do JSON
        std::string tipo;
        std::string mensagem;

        printf("Conectado com sucesso\r\n");
        
        //### Liga o LED verde
        ledON  = 1;
        //### Desliga o LED vermelho
        ledOFF = 0;
        
        char recv[256];
        int res = ws.send("{\"tipo\": \"conexao\", \"mensagem\": \"Freescale Pet IoT - Conectado\", \"destino\": \"ws/cliente\" }");
        while (1) {
            if (ws.read(recv)) {
                printf("Dados recebidos: %s\r\n", recv);
                parse(mensagemJSON, recv);
                tipo      = mensagemJSON["tipo"].get<std::string>();
                mensagem  = mensagemJSON["mensagem"].get<std::string>();
                
                if (tipo == "comida"){
                        if(mensagem == "liberar"){
                            printf("Recebendo evento comida\r\n");
                            int i;
                            for (i=0; i < 200; ++i) {
                                servo = 1; // Toggle the LED state
                                wait_ms(1); // 200 ms
                                servo = 0; // LED is OFF
                                wait_ms(10); // 1 sec
                            }
                            MbedJSONValue json;
                            std::string str;
                            json["tipo"]        = "resp_comida";
                            json["mensagem"]    = "Comida liberada com sucesso";
                            json["destino"]     = "ws/cliente";
                            str                 = json.serialize();
                            char *jsonChar = new char[str.length() + 1];
                            strcpy(jsonChar, str.c_str());
                            ws.send(jsonChar);
                            delete [] jsonChar;
                        } 
               }
               else if(tipo == "reservatorio"){
                        if(mensagem == "consultar"){
                            int total = 20; //Distancia total em CM do reservatorio vazio
                            int percentual = 0;
                            usensor.start();
                            wait_ms(500); 
                            dist=usensor.get_dist_cm();
                            printf("Distancia em CM:%ld\r\n",dist);
                            if(dist != 0 && dist != NULL){
                                percentual = (int)((dist*100)/total);
                                percentual = 100-percentual;
                            }
                            MbedJSONValue json;
                            std::string str;
                            json["tipo"]        = "resp_reservatorio";
                            json["mensagem"]    = percentual;
                            json["destino"]     = "ws/cliente";
                            str                 = json.serialize();
                            char *jsonChar = new char[str.length() + 1];
                            strcpy(jsonChar, str.c_str());
                            ws.send(jsonChar);
                            delete [] jsonChar;
                        }
               }
               else if(tipo == "sensor_movimento"){
                        if(motion_detected) {
                            MbedJSONValue json;
                            std::string str;
                            json["tipo"]        = "resp_sensor_movimento";
                            json["mensagem"]    = "Movimento detectado, seu animal quer comida.";
                            json["destino"]     = "ws/cliente";
                            str                 = json.serialize();
                            char *jsonChar = new char[str.length() + 1];
                            strcpy(jsonChar, str.c_str());
                            ws.send(jsonChar);
                            delete [] jsonChar;
                        }
               }
               else if(tipo == "toca_audio") {
                        int i;
                        //### Toca 3 vezes o beep                        
                        for (i=0; i < 3; ++i) {
                            buzzer = 1;
                            wait(.5);
                            buzzer = 0;
                            wait(.5);
                            printf("Conectado com sucesso\r\n");
                        }
                        MbedJSONValue json;
                        std::string str;
                        json["tipo"]        = "resp_toca_audio";
                        json["mensagem"]    = "Audio emitido com sucesso";
                        json["destino"]     = "ws/cliente";
                        str                 = json.serialize();
                        char *jsonChar = new char[str.length() + 1];
                        strcpy(jsonChar, str.c_str());
                        ws.send(jsonChar);
                        delete [] jsonChar;
               }
               else if(tipo == "temp_humidade"){
                        int tentativasLeitura = 10;
                        for(int i=0;i < tentativasLeitura; ++i){
                            err = sensor.readData();
                            if(err == 0) {
                                break;
                            }
                            wait(0.5);
                        }
                        if (err == 0) {
                            MbedJSONValue json;
                            std::string str;
                            json["tipo"]        = "resp_temp_humidade";
                            json["mensagem"]    = "Dados de temperatura e humidade capitado com sucesso";
                            json["temperatura"] = (int)(sensor.ReadTemperature(CELCIUS) * 1 + 0.5);
                            json["humidade"]    = (int)sensor.ReadHumidity();
                            json["destino"]     = "ws/cliente";
                            str                 = json.serialize();
                            char *jsonChar = new char[str.length() + 1];
                            strcpy(jsonChar, str.c_str());
                            ws.send(jsonChar);
                            delete [] jsonChar;
                        } else {
                            printf("Erro ao ler a temperatura e humidade\r\n");
                        }
               } else {
                    //### Mensagem nao reconhecida
               }
            }
            /*
             *   Mensagens serem enviadas como notificacao e 
             */
            //### Verifica o nivel do reservatorio para ver se precisa avisar o usuario
            int total = 18; //Distancia total em CM do reservatorio vazio
            int percentual = 0;
            usensor.start();
            wait_ms(500); 
            dist=usensor.get_dist_cm();
            printf("Distancia em CM:%ld\r\n",dist);
            if(dist != 0 && dist != NULL){
                percentual = (int)((dist*100)/total);
                percentual = 100-percentual;
            }
            if(percentual > 5 && percentual < 10){
                printf("Nivel do reservatorio esta baixo, avisar usuario\r\n");
                MbedJSONValue json;
                std::string str;
                json["tipo"]        = "alerta";
                json["mensagem"]    = "Nivel do reservatorio esta baixo, coloque mais racao no reservatorio";
                json["destino"]     = "ws/cliente";
                str                 = json.serialize();
                char *jsonChar = new char[str.length() + 1];
                strcpy(jsonChar, str.c_str());
                ws.send(jsonChar);
                delete [] jsonChar;
            }
            //### Verifica se teve movimento para avisar o usuario
            if(motion_detected) {
                printf("Movimento detectado\r\n");
                MbedJSONValue json;
                std::string str;
                json["tipo"]        = "alerta";
                json["mensagem"]    = "Movimento detectado, seu animal quer comida.";
                json["destino"]     = "ws/cliente";
                str                 = json.serialize();
                char *jsonChar = new char[str.length() + 1];
                strcpy(jsonChar, str.c_str());
                ws.send(jsonChar);
                delete [] jsonChar;
                motion_detected = 0;
            }
            //### Verifica alera para alta temperatura e ou baixa humidade
            err = sensor.readData();
            if (err == 0) {
                int temperatura = (int)(sensor.ReadTemperature(CELCIUS) * 1 + 0.5);
                int humidade    = (int)sensor.ReadHumidity();
                if(temperatura > 30 || humidade < 30){
                    MbedJSONValue json;
                    std::string str;
                    json["tipo"]            = "alerta";
                    if(temperatura > 30){
                        json["mensagem"]    = "Atencao, alta temperatura nao deixe de dar agua para o seu animal.";
                    } else {
                        json["mensagem"]    = "Atencao, baixa humidade, nao deixe de dar agua para o seu animal.";
                    }
                    json["temperatura"] = (int)(sensor.ReadTemperature(CELCIUS) * 1 + 0.5);
                    json["humidade"]    = (int)sensor.ReadHumidity();
                    json["destino"]     = "ws/cliente";
                    str                 = json.serialize();
                    char *jsonChar = new char[str.length() + 1];
                    strcpy(jsonChar, str.c_str());
                    printf(str.c_str());
                    ws.send(jsonChar);
                    delete [] jsonChar;
                }
            } 
            //### Verifica termperatura / humidade
            wait(0.5);
        }
    } else {
        //Ligado led vermelho
        printf("Nao foi possivel conectar com servidor\r\n");
        //### Desliga o LED verde
        ledON  = 0;
        //### Liga o LED vermelho
        ledOFF = 1;
    }
}