
/*Graduated Night light with Seed Grove Ambient Light sensor
Casey Lively
March 2016*/

//Read in ambient light sensor with mbed LPC1768
#include "mbed.h"

AnalogIn sensor(p20);//
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

int main() {
    float val;
    float threshold = .03; //User specified for night-light mode. Set to .03 for light measurement mode
    while(1) {
        val = sensor.read();
        printf("Sensor reading: %2.2f - %2.2f\r\n", val, (float)(1023-val)*10/val);
        
        if(val <= threshold)
             led4 = 1;
        else
            led4 = 0;
        
        if(val <= 0.1)
            led3 = 1;
        else
            led3 = 0;
            
        if(val <= 0.35)
            led2 = 1;
        else
            led2 = 0;
            
        if(val <= 0.55)
            led1 = 1;
        else
            led1 = 0;
        
       
        wait(0.1);
    }//end while(1)
}//end Main
