/*
 * Copyright (C) 2015 Wiznet, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include "mbed.h"
#include "WizFi310Interface.h"
#include "Dht11.h"

#define AP_SSID        "SSID" 
#define AP_PASSWORD    "PASSWORD" 
#define AP_SECURITY    NSAPI_SECURITY_WPA2

#define USER_ID        "USER ID"
#define CREDENTIAL_ID  "Credential ID"
#define SERVICE_ID     "Service ID"
#define DEVICE_ID      "Device ID"
#define COMMAND_NM     "Command Name"
#define CONTAINER_NAME "Container Name"

#define LED             LED_Sensor

#if defined(TARGET_WIZwiki_W7500)
    Serial pc(USBTX, USBRX);
    WizFi310Interface wifi(D1, D0, D7, D6, D9, NC, 115200);

    DigitalOut  myled ( LED );
#endif


int main()
{       
    pc.baud(115200);
 
    printf("WizFi310 ThingPlug Connect_Simple Control. \r\n");
    if ( wifi.connect(AP_SSID, AP_PASSWORD, AP_SECURITY))     return -1;
    printf("IP Address is %s\r\n\r\n", wifi.get_ip_address());
    
    wifi.conTP(USER_ID, CREDENTIAL_ID, SERVICE_ID, DEVICE_ID, CONTAINER_NAME, COMMAND_NM);
    printf("Start!\r\n\r\n");
    while(true)
    {                   
        int a;
        a = wifi.recvTP(COMMAND_NM, 3, 0);
        
        if( a == 1 )
        {
            printf("Turn On!\r\n\r\n");
            myled = 1;
        }
        
        else if( a == 2)
        {
            printf("Turn OFF!\r\n\r\n");
            myled = 0;
        }        
        wait_ms(3000);
    }
}