/*
 * Copyright (C) 2015 Wiznet, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include "mbed.h"
#include "WizFi310Interface.h"
#include "Dht11.h"

#define AP_SSID        "SSID" 
#define AP_PASSWORD    "PASSWORD" 
#define AP_SECURITY    NSAPI_SECURITY_WPA2

#define USER_ID        "USER ID"
#define CREDENTIAL_ID  "Credential ID"
#define SERVICE_ID     "Service ID"
#define DEVICE_ID      "Device ID"
#define COMMAND_NM     "Command Name"
#define CONTAINER_NAME "Container Name"

#define CDS_SENSOR      CDS_Sensor
#define DHT_SENSOR      DHT_Sensor

#if defined(TARGET_WIZwiki_W7500)
    Serial pc(USBTX, USBRX);
    WizFi310Interface wifi(D1, D0, D7, D6, D9, NC, 115200);
    
    AnalogIn    myLux( CDS_SENSOR );
    Dht11       myTemp( DHT_SENSOR );
#endif

int main()
{
    int error = 0;
    char str[50] = "";
    
    int lux;
    double temp;
    int humid;
    
    pc.baud(115200);
 
    printf("WizFi310 ThingPlug Connect. \r\n");
    if ( wifi.connect(AP_SSID, AP_PASSWORD, AP_SECURITY))     return -1;
    printf("IP Address is %s\r\n\r\n", wifi.get_ip_address());
    
    wifi.conTP(USER_ID, CREDENTIAL_ID, SERVICE_ID, DEVICE_ID, CONTAINER_NAME, COMMAND_NM);
    while(true)
    {   
        printf("Send - s, , Response - r, Quit - q\r\n");
        printf("Input : ");
        
        char c = pc.getc();
        printf("%c\r\n", c);
        
        if(c =='s' || c == 'S')
        {
            error = myTemp.read();
            if( error == 0 )
            {
                lux = (int)(myLux.read()*1000);
                temp = (double)(myTemp.getCelsius());
                humid = (int)myTemp.getHumidity();
                
                sprintf((char *)str, "0106%08x0206%08x0306%08x", 
                lux, (int)temp, humid);
                
                printf("lux value : %04d, temp value : %.1lf, humidity value : %04d\r\n", 
                        lux, temp, humid);
                        
                printf("Send Data : %s\r\n\r\n\r\n", str);
                
                wifi.sendTP(CONTAINER_NAME, str);
            }
                        
            else
                printf("Send failed\r\n\r\n");
                
            wait_ms(3000);
        }
        
        else if(c == 'r' || c == 'R')
        {
            wifi.recvTP(COMMAND_NM, 3, 0);
            
            wait_ms(3000);
        }
        
        else if(c == 'q' || c == 'Q')
        {
            wifi.disConTP();
            break;
        }
    }
    wifi.disconnect();
}