/*
 * Copyright (C) 2015 Wiznet, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include "mbed.h"
#include "Dht11.h"
#include "WizFi310Interface.h"

#define DHT_SENSOR DHT_SENSOR

#if defined(TARGET_WIZwiki_W7500)
Serial pc(USBTX, USBRX);
WizFi310Interface wifi(D1, D0, D7, D6, D9, NC, 115200);

Dht11 myTemp  ( DHT_SENSOR );
#endif

int main()
{
    int error = 0;
    char str[50] = "";
        
    pc.baud(115200);
 
    printf("WizFi310 Shield Test. \r\n");

    while(true)
    {
        error = myTemp.read();
        if( error != 0 )
        {
            printf("Connection failed\r\n\r\n");
            break;
        }
                   
        sprintf((char *)str, "{\"temp value\": %.1lf(c), \"humidity value\": %d(%%)}"
                ,(double)(myTemp.getCelsius()), myTemp.getHumidity());
                
        printf("%s\r\n\r\n", str);
        
        wait_ms(5000);
    }
}