/* WizFi310 
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "WizFi310.h"

bool WizFi310::startup(void)
{
    reset();

    cmdAT();
    if( cmdMECHO(false) == -1)  return false;
    //if( cmdMECHO(true) == -1) return false;
    if(_cts != NULL && _rts != NULL)
    {
        if( cmdUSET(_baud,"HW") == -1)  return false;
    }
    else
    {
        if( cmdUSET(_baud,"N") == -1)   return false;
    }
    wait_ms(1000);
    if( cmdAT() == -1)          return false;

    return true;
}

bool WizFi310::reset(void)
{
    _reset = 0;
    wait_ms(500);
    _reset = 1;

    return true;
}
