
#define __DEBUG__ 5
#ifndef __MODULE__
#define __MODULE__ "MainThread.cpp"
#endif
#include "MyDebug.h"

#include "mbed.h"

#include "MyOsHelpers.h"
#include "MyThread.h"
#include "MyBlinker.h"
#include "IMUSensor.h"
#include "GPSSensor.h"
#include "CANInterface.h"
#include "CANSniffer.h"
#include "PyrnUSBModem.h"

#include "HTTPClient.h"
//#include "TCPSocketConnection.h"

char dataResult[1024];

#if 0
void test(void const*) {

    DBG("Start");

    //HTTPClient http;
    //TCPSocketConnection tcpSock;
    
    IMUSensor imu(p28,p27);
    GPSSensor gps(p13,p14,4,250);
    CANInterface canItf;
    CANSniffer canSnif(&canItf);
    //PyrnUSBModem modem;
    
    PrintActiveThreads();
    
    //modem.connect("a2bouygtel.com","","");

    PwmOut led_red(LED1);
    PwmOut led_green(LED2);

    MyBlinker br = MyBlinker(&led_red,1000);
    MyBlinker bg = MyBlinker(&led_green,2000);

    imu.Start();
    gps.Start();
    canItf.Start();
    br.Start();
    bg.Start();

    imu.Run();
    gps.Run();
    canItf.Run();
    br.Run();
    bg.Run();
    
    // ecrire dans 5 et 6
    char cbuff[8] = {'C','A','N','1','[',' ',' ',']'};
    uint16_t loop = 0;
    uint16_t len = 0;
    
    while(1) {
        // Fill up the cbuff
        cbuff[5] = 0xff & (loop>>8);
        cbuff[6] = 0xff & loop;
        // Print all threads
        PrintActiveThreads();
        Thread::wait(1000);
        time_t seconds = time(NULL);
        if((loop % 20) == 0) {
            gps.Capture(dataResult,&len);
            DBG("GPS[%04d] Got %03d chars",seconds,len);
        }
        if((loop % 30) == 0) {
            imu.Capture(dataResult,&len);
            DBG("IMU[%04d] Got %03d chars",seconds,len);
        }
        /*
        if((loop%10) == 0) {
            DBG("Trying to fetch page...\n");
            int ret = http.get("http://developer.mbed.org/media/uploads/donatien/hello.txt", dataResult, 128);
            if (!ret)
            {
              DBG("Page fetched successfully - read %d characters\n", strlen(dataResult));
              DBG("Result: %s\n", dataResult);
            } else {
              DBG("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
            }
        }
        */
        /*
        if((loop%10) == 0) {
            char rcvBuf[16];
            if(modem.pppConnected()) {
                DBG("====> PPP is connected go for TCP Socket");
                if(!tcpSock.is_connected()) {
                    if(tcpSock.connect("carbon14.clemounet.fr",8888) == 0){
                    //if(tcpSock.connect("195.154.85.42",8888) == 0){
                         DBG("TCP Socket got Connected");
                    } else {
                         DBG("TCP Socket could not Connected");
                    }
                }
                if(tcpSock.is_connected()) {
                //if(tcpSock.connect("carbon14.clemounet.fr",8888) == 0){
                    DBG("TCP Socket is Connected");
                    if(tcpSock.send(cbuff,8)){
                        DBG("TCP Data Sent ... now receive");
                        int n = tcpSock.receive(rcvBuf, 16);
                        if(n) {
                            DBG("TCP Data Received");
                            DBG_MEMDUMP("TCP RCV",rcvBuf,n);
                        } else {
                            DBG("TCP Data Receive Failed");
                        }
                    } else {
                        DBG("TCP Failed to send data");
                        
                    }
                } else {
                    DBG("TCP Socket not connected");
                }
            }
        }
        */
        canItf.Send(1,0x666,cbuff,8);
        loop++;
    }
    
    imu.Stop();
    gps.Stop();
    canItf.Stop();
    br.Stop();
    bg.Stop();
}
#endif

void ModemLuncher(void const*) {
    DBG("Start");
    HTTPClient http;
    PyrnUSBModem modem;
    
    PrintActiveThreads();
    
    Thread::wait(500);
    modem.connect("a2bouygtel.com","","");
    int loop = 0;
    
    while(1) {
        DBG("LoopThread");
        Thread::wait(1000);
        
        if((loop%10) == 0) {
            PrintActiveThreads();
            DBG("Trying to fetch page...\n");
            int ret = http.get("http://developer.mbed.org/media/uploads/donatien/hello.txt", dataResult, 128);
            if (!ret)
            {
              DBG("Page fetched successfully - read %d characters\n", strlen(dataResult));
              DBG("Result: %s\n", dataResult);
            } else {
              DBG("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
            }
        }
        
        /*
        if((loop%10) == 0) {
            char rcvBuf[16];
            if(modem.pppConnected()) {
                DBG("====> PPP is connected go for TCP Socket");
                if(!tcpSock.is_connected()) {
                    if(tcpSock.connect("carbon14.clemounet.fr",8888) == 0){
                    //if(tcpSock.connect("195.154.85.42",8888) == 0){
                         DBG("TCP Socket got Connected");
                    } else {
                         DBG("TCP Socket could not Connected");
                    }
                }
                if(tcpSock.is_connected()) {
                //if(tcpSock.connect("carbon14.clemounet.fr",8888) == 0){
                    DBG("TCP Socket is Connected");
                    if(tcpSock.send(cbuff,8)){
                        DBG("TCP Data Sent ... now receive");
                        int n = tcpSock.receive(rcvBuf, 16);
                        if(n) {
                            DBG("TCP Data Received");
                            DBG_MEMDUMP("TCP RCV",rcvBuf,n);
                        } else {
                            DBG("TCP Data Receive Failed");
                        }
                    } else {
                        DBG("TCP Failed to send data");
                        
                    }
                } else {
                    DBG("TCP Socket not connected");
                }
            }
        }
        */
        loop++;
    }
}


int main(void) {
    
    set_time(0);
    debug_init();
    debug_set_newline("\r\n");
    debug_set_speed(115200);
    
    // Simply lunch the modem stuffs in separate thread, (not using the MyThread Stuffs)
    // >>>> It allows to do other stuffs during this dead time <<<<
    Thread testTask(ModemLuncher, NULL, osPriorityNormal, 1024 * 5);
    
    //IMUSensor imu(p28,p27);
    //GPSSensor gps(p13,p14,4,250);
    //CANInterface canItf;
    //CANSniffer canSnif(&canItf);
    
    //PwmOut led_red(LED1);
    //PwmOut led_green(LED2);

    //MyBlinker br = MyBlinker(&led_red,1000);
    //MyBlinker bg = MyBlinker(&led_green,2000);

    //imu.Start();
    //gps.Start();
    //canItf.Start();
    //br.Start();
    //bg.Start();

    //imu.Run();
    //gps.Run();
    //canItf.Run();
    //br.Run();
    //bg.Run();
    
    // ecrire dans 5 et 6
    char cbuff[8] = {'C','A','N','1','[',' ',' ',']'};
    uint16_t loop = 0;
    uint16_t len = 0;
    
    while(1){
        // Fill up the cbuff
        cbuff[5] = 0xff & (loop>>8);
        cbuff[6] = 0xff & loop;
        // Print all threads
        PrintActiveThreads();
        Thread::wait(1000);
        time_t seconds = time(NULL);
        /*if((loop % 20) == 0) {
            gps.Capture(dataResult,&len);
            DBG("GPS[%04d] Got %03d chars",seconds,len);
        }
        if((loop % 30) == 0) {
            imu.Capture(dataResult,&len);
            DBG("IMU[%04d] Got %03d chars",seconds,len);
        }*/
        DBG("LoopMain");
        //canItf.Send(1,0x666,cbuff,8);
        Thread::wait(1000);  
        loop++;   
    }
    
    //imu.Stop();
    //gps.Stop();
    //canItf.Stop();
    //br.Stop();
    //bg.Stop();
    
    return 0;
}