
#include "MyThread.h"
#include "MyLibc.h"

#define __DEBUG__ 0
#ifndef __MODULE__
#define __MODULE__ "MyThread.cpp"
#endif
#include "MyDebug.h"


void MainTrampoline(void const *args){
    MyThread *mt = (MyThread*) args;
    mt->Main();
    mt->t->signal_set(ENDSIG);
    mt->t->terminate();
}

MyThread::MyThread(const char* name,uint32_t sz){
    stackSize = sz;
    tName = strdup(name);
}

MyThread::~MyThread() {
    free((char*)tName);
}

void MyThread::Start(void){
    running = true;
}

void MyThread::Stop(void){
    running = false;
}

void MyThread::Run(void){
    t = new Thread(MainTrampoline,this,osPriorityNormal,stackSize);
}

void MyThread::Wait(int32_t ms){
    t->wait(ms);
}

void MyThread::WaitEnd(){
    t->signal_wait(ENDSIG);
}