
#include "MyOsHelpers.h"


#define __DEBUG__ 5
#ifndef __MODULE__
#define __MODULE__ "MyOsHelpers.c"
#endif
#include "MyDebug.h"

//extern void *os_active_TCB[];
#include "RTX_Conf.h"

/* List head of chained ready tasks */
extern struct OS_XCB os_rdy;
/* List head of chained delay tasks */
extern struct OS_XCB os_dly;

void PrintThreadInfo(P_TCB ptcb) {
    uint32_t r = ptcb->tsk_stack - (int32_t)(ptcb->stack);
    DBG("T[%d][%03d] %s | %05d | %p | %08x | %05d", ptcb->cb_type, ptcb->task_id, StateLabelForInt(ptcb->state), ptcb->priv_stack, ptcb->stack,  ptcb->tsk_stack, ptcb->priv_stack-r);
}
    
void PrintActiveThreads(void) {
    P_TCB ptask;
    uint16_t i = 0;
    while(1) {
        ptask = (P_TCB)os_active_TCB[i];
        //DBG("%p",ptask);
        if(ptask == NULL)
            break;
        else
            PrintThreadInfo(ptask);
        i++;
    }
}

void PrintRDYThreads(void) {
    DBG("=== Print RDY ===");
    P_TCB ptcb = os_rdy.p_lnk;
    while(ptcb) {
        PrintThreadInfo(ptcb);
        // go next
        ptcb = ptcb->p_lnk;
    }
}

void PrintDLYThreads(void) {    
    DBG("=== Print DLY ===");
    P_TCB ptcb = os_dly.p_dlnk;
    while(ptcb) {
        PrintThreadInfo(ptcb);
        // go next
        ptcb = ptcb->p_dlnk;
    }
}

const char *StateLabelForInt(uint8_t s) {
    switch(s){
        case INACTIVE:  return INACTIVE_LBL;
        case READY:     return READY_LBL;
        case RUNNING:   return RUNNING_LBL;
        case WAIT_DLY:  return WAIT_DLY_LBL;
        case WAIT_ITV:  return WAIT_ITV_LBL;
        case WAIT_OR:   return WAIT_OR_LBL;
        case WAIT_AND:  return WAIT_AND_LBL;
        case WAIT_SEM:  return WAIT_SEM_LBL;
        case WAIT_MBX:  return WAIT_MBX_LBL;
        case WAIT_MUT:  return WAIT_MUT_LBL;
        default:        return "UNKNOWN";
    }
}