
#include "MyBlinker.h"

#define BLINKER_THREAD_STACK_SIZE   128

MyBlinker::MyBlinker(PwmOut *o, int32_t d, float hState, float lState): MyThread("MyBlinker",BLINKER_THREAD_STACK_SIZE) {
    led = o;
    delay = d;
    highState = hState;
    lowState = lState;
}

void MyBlinker::setDelay(int32_t d) {
    delay = d;
}

void MyBlinker::setHighState(float hState) {
    highState = hState;
}

void MyBlinker::setLowState(float lState) {
    lowState = lState;
}

void MyBlinker::Main(void) {
    while(running){
        led->write(highState);
        Wait(delay);
        led->write(lowState);
        Wait(delay);
    }
}
