
#ifndef MYSENSOR_H
#define MYSENSOR_H

#include "MyThread.h"
#include "rtos.h"

#define SENSOR_NAME_NONE    "SENSORNONE"
#define SENSOR_TYPE_NONE    0
#define SENSOR_NAME_IMU     "SENSORIMU"
#define SENSOR_TYPE_IMU     1
#define SENSOR_NAME_CAN     "SENSORCAN"
#define SENSOR_TYPE_CAN     2
#define SENSOR_NAME_GPS     "SENSORGPS"
#define SENSOR_TYPE_GPS     3    

#define SENSOR_RESSZ_DEFAULT -1

class MySensor:public MyThread {
protected:
    uint8_t sensorType;
    typedef struct _dataResult{
        uint8_t *start;
        uint8_t *current;
        uint16_t num;
        uint16_t max;
        bool dynamic;
    } dataResult;
    dataResult results;
    Mutex resultsMutex;
    uint32_t idleTime;
public:
    MySensor(const char* sName = SENSOR_NAME_NONE, uint8_t type = SENSOR_TYPE_NONE, uint32_t idle = 1000, uint32_t sz = DEFAULT_STACK_SIZE);
    virtual ~MySensor();
    virtual const char *GetSensorName();
    virtual uint8_t GetSensorType();
    virtual void SetIdleTime(uint32_t it);
    virtual void Main();
    virtual void InitResults(int16_t size);
    virtual void ReleaseResults();
    virtual void InitResultsStatic() = 0;
    virtual void Loop() = 0;
    virtual void StoreLastImpact(void) = 0;
    virtual void Capture(char *data, uint16_t *len);
};

#endif