
#include "CANSniffer.h"
#include "CAN.h"

#define __DEBUG__ 5
#ifndef __MODULE__
#define __MODULE__ "CANSniffer.cpp"
#endif
#include "MyDebug.h"

CANSniffer::CANSniffer(CANInterface *itf){
    if(itf) {
        canItf = itf;
        itf->AddCallBackForId(CAN_ID_PROMISCUOUS_MODE,this);
    }
}

void CANSniffer::event(int ID, void *data) {
    //char buff[23];
    if(ID == 1) {
        // Remember we don't own the CANMessage here.
        CANMessage *msg = (CANMessage*) data; 
        //sprintf(buff,"CANSniffer [%08x]:",msg->id);
        //DBG_MEMDUMP((const char*)buff,(const char*)msg->data,msg->len);
        int id = msg->id;
        unsigned char *data = msg->data;
        DBG("Received CAN [%08x]-%02X %02X %02X %02X %02X %02X %02X %02X",id,data[0],data[1],data[2],data[3],data[4],data[5],data[6],data[7]);
    }
}