
#ifndef CAN_INTERFACE_H
#define CAN_INTERFACE_H

#include "MyThread.h"
#include "MyCallBack.h"
#include "CAN.h"
#include "CANFifoMessage.h"

#define CAN_ID_PROMISCUOUS_MODE 0xffffffff      

#define CAN_SIMULTANEOUS_CBS    8
#define CAN_SIMULTANEOUS_MSG    15

class CANInterface: public MyThread {
protected:
    typedef struct _idCbEntry{
        uint32_t id;            // 29b and 11b can ids are supported
        MyCallBack *cb;
    } idCbEntry;
    
    Mutex idCbTableMutex;
    Mutex sendMutex;
    
    uint8_t nCurrentCbs;           // How much entries we got in our table
    idCbEntry idCbTable[CAN_SIMULTANEOUS_CBS];     // This mean that we allow at most 8 sensors to receive events simultaneously
    
    CAN *bus1;
    CAN *bus2;
    
    bool rxOvf;
    CANFifoMessage fifoRxMsg;
    CANMessage msgTx;

public:
    CANInterface();
    virtual void Configure(uint8_t ifaceNumber, int speed);
    virtual void AddCallBackForId(int id, MyCallBack *cb);
    virtual void DellCallBackForId(int id);
    virtual void DispatchCANMessage(CANMessage *msg);
    virtual int  Send(uint8_t ifaceNumber,int id, char *data, uint8_t len);
    virtual void Main();
    
    virtual void RxCbCan1(void);
    virtual void RxCbCan2(void);
        
    virtual CAN *GetCan1() { return bus1; }
    virtual CAN *GetCan2() { return bus2; }
};

#endif