/* mbed XMON library. 
    
    XMON Micro controller serial port debugger variable view realtime curve tracer
    http://webx.dk/XMON/index.htm
    
    XMON is a windows program that show and plot value received fomr the serial port.
    This is the banner from the XMON documentation:
    // XMON 2.1 ALPHA (autoscaling on/off/min/max) 15 feb 2008
    // XMON is a free utility for monitoring and communication with MCU development
    // Made by DZL (help ideas support testing TST)
    // if this program help you and you are happy to use it, please donate a fee to thomas@webx.dk via paypal
    // any donation will be put into improving XMON, any size of donation small or big will be most appliciated.
    // suggestions and bugs to thomas@webx.dk
    // we will setup a homepage with features and tips and tricks and so on soon, see webx.dk and dzl.dk 

    Copyright (c) 2011 NXP 3786 
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/
#include "mbed.h"
#include "XMONlib.h"

XMON::XMON( PinName tx, PinName rx) : Serial(tx, rx)
{
}

/** Clear and restart x axis for the specified trace
 *
 * @param trace trace value
 */
void XMON::plotZero( unsigned int trace)
{               // value is the plot trace you want to zero on XMON
  putc('*');
  putc('T');  // re Trigger 'T', clear all traces and restart X axis scaling 'C'
  putc( (unsigned char)trace);
}

/** Clear all trace and restart x axis
 * @param none
 */
void XMON::plotZero( void)
{               
  putc('*');
  putc('T');  // re Trigger 'T', clear 
  putc( 0);
  
  putc('*');
  putc('T');  // re Trigger 'T', clear 
  putc( 1);

  putc('*');
  putc('T');  // re Trigger 'T', clear 
  putc( 2);
  
  putc('*');
  putc('T');  // re Trigger 'T', clear 
  putc( 3);
}

/** Plot float data
 *
 * @param data float value to plot.
 * @param trace color graph
 */
void XMON::plotf( float data, unsigned int trace)
{
    putc('*');
    putc('d');
    putc(((char*)&data)[3]);
    putc('D');
    putc(((char*)&data)[2]);
    putc('D');
    putc(((char*)&data)[1]);
    putc('D');
    putc(((char*)&data)[0]);
    putc('F'); // here is the data handler selector indicator to XMON
    putc( (unsigned char)trace);
}

/** View float data
 *
 * @param data float value to view.
 * @param line line label
 */
void XMON::viewf( float data, unsigned int trace)
{
    putc('*');
    putc('d');
    putc(((char*)&data)[3]);
    putc('D');
    putc(((char*)&data)[2]);
    putc('D');
    putc(((char*)&data)[1]);
    putc('D');
    putc(((char*)&data)[0]);
    putc('f');// here is the data handler selector indicator to XMON
    putc( (unsigned char)trace);
}

/** Plot signed 32 bits data
 *
 * @param data signed 32bit value to plot.
 * @param trace color graph
 */
void XMON::plotl( int data,unsigned int trace)
{
    putc('*');
    putc('d');
    putc(((char*)&data)[3]);
    putc('D');
    putc(((char*)&data)[2]);
    putc('D');
    putc(((char*)&data)[1]);
    putc('D');
    putc(((char*)&data)[0]);
    putc('I');                    // here is the data handler selector indicator to XMON
    putc( (unsigned char)trace);
}

/** View signed 32 bits data
 *
 * @param data unsigned short value to view.
 * @param line line label
 */
void XMON::viewl( int data, unsigned int trace) 
{
    putc('*');
    putc('d');
    putc(((char*)&data)[3]);
    putc('D');
    putc(((char*)&data)[2]);
    putc('D');
    putc(((char*)&data)[1]);
    putc('D');
    putc(((char*)&data)[0]);
    putc('i');                        // here is the data handler selector indicator to XMON
    putc( (unsigned char)trace);
}


/** Plot unsigned 16 bits data
 *
 * @param data unsigned short value to plot.
 * @param trace color graph
 */
void XMON::plot( unsigned short data, unsigned int trace) 
{                               
  putc('*');
  putc('d');
  putc( (unsigned char)(data>>8));
  putc('D');
  putc( (unsigned char)data);
  putc('P');                    // here is the data handler selector indicator to XMON
  putc( (unsigned char)trace);
}

/** View unsigned 16 bits data
 *
 * @param data unsigned short value to view.
 * @param line line label
 */
void XMON::view( unsigned short data, unsigned int line) // Unsigned Integers 16 bits values in the VIEW variable value area
{
  putc('*');
  putc('d');
  putc( (unsigned char)(data>>8));
  putc('D');
  putc( (unsigned char)data);
  putc('V');// here is the data handler selector indicator to XMON
  putc( (unsigned char)line);
}

/** Put the PLOT GRAPH in auto scale mode
 *
 * @param s 0 auto scale OFF, 1 auto scale ON
 */
void XMON::autoscale( char s) // 
{
   putc('*');
   putc('A');
   putc(s);
}

/*

void ViewFreqBin( int data)
{
    viewl( data, XMON_RED);

}

void PlotSpectrum( int * specarray, float data)
{
    unsigned int i=0;

    plotZero( XMON_RED);

    viewf( data, XMON_RED);
  
    while ( i < NBIN/2)
    {
        plot( specarray[i], XMON_RED);
        i++;
    }
}

*/