/* mbed XMON library. 
*    
*    XMON Micro controller serial port debugger variable view realtime curve tracer
*    http://webx.dk/XMON/index.htm
*    
*    XMON is a windows program that show and plot value received fomr the serial port.
*    This is the banner from the XMON documentation:
*    // XMON 2.1 ALPHA (autoscaling on/off/min/max) 15 feb 2008
*    // XMON is a free utility for monitoring and communication with MCU development
*    // Made by DZL (help ideas support testing TST)
*    // if this program help you and you are happy to use it, please donate a fee to thomas@webx.dk via paypal
*    // any donation will be put into improving XMON, any size of donation small or big will be most appliciated.
*    // suggestions and bugs to thomas@webx.dk
*    // we will setup a homepage with features and tips and tricks and so on soon, see webx.dk and dzl.dk 
*
*    Copyright (c) 2011 NXP 3786 
* 
*    Permission is hereby granted, free of charge, to any person obtaining a copy
*    of this software and associated documentation files (the "Software"), to deal
*    in the Software without restriction, including without limitation the rights
*    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
*    copies of the Software, and to permit persons to whom the Software is
*    furnished to do so, subject to the following conditions:
* 
*    The above copyright notice and this permission notice shall be included in
*    all copies or substantial portions of the Software.
* 
*    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
*    THE SOFTWARE.
*/

#ifndef __MBED_XMONLIB_H
#define __MBED_XMONLIB_H

#include "mbed.h"

#define XMON_AUTO_SCALE_OFF 0
#define XMON_AUTO_SCALE_ON 1
#define XMON_RED 0          // Colors of the PLOT GRAPHS
#define XMON_GREEN 1
#define XMON_BLUE 2
#define XMON_YELLOW 3

/** XMON Micro controller serial port debugger
 *
 * @code
 * #include "mbed.h"
 * #include "XMONlib.h"
 *
 * XMON xm( USBTX, USBRX);
 *
 * int main()
 * {
 *   // Set the rate to XMON. Remenber to change the program too...
 *   xm.baud( 115200);
 *   ....
 *   xm.viewf( 3.1415, 0);    // view pi value
 *   xm.view( 100, 1);        // view an integer value
 *
 *   xm.plotZero();            // clear the plot area
 *   for (int i=0; i<128; i++)
 *   {
 *       xm.plot( i, 0);       // plot the i value...
 *   }
 *
 *
 */
 
class XMON : public Serial 
{

public:

    XMON( PinName tx, PinName rx);
    
    /** Clear and restart x axis for the specified trace
     *
     * @param trace trace value
     */
    void plotZero( unsigned int trace);
    
    /** Clear all trace and restart x axis
     * @param none
     */
    void plotZero( void);
    
    /** Plot float data
     *
     * @param data float value to plot.
     * @param trace color graph
     */
    void plotf( float data, unsigned int trace);
    
    /** View float data
     *
     * @param data float value to view.
     * @param line line label
     */
    void viewf( float data, unsigned int trace);
    
    /** Plot signed 32 bits data
     *
     * @param data signed 32bit value to plot.
     * @param trace color graph
     */
    void plotl( int data,unsigned int trace);
    
    /** View signed 32 bits data
     *
     * @param data unsigned short value to view.
     * @param line line label
     */
    void viewl( int data, unsigned int trace);
    
    /** Plot unsigned 16 bits data
     *
     * @param data unsigned short value to plot.
     * @param trace color graph
     */
    void plot( unsigned short data, unsigned int trace);
    
    /** View unsigned 16 bits data
     *
     * @param data unsigned short value to view.
     * @param line line label
     */
    void view( unsigned short data, unsigned int line);
    
    /** Put the PLOT GRAPH in auto scale mode
     *
     * @param s 0 auto scale OFF, 1 auto scale ON
     */
    void autoscale( char s);

};

#endif