#ifndef __VAWE_DATA_H
#define __VAWE_DATA_H

/** Data struct to manage the data file created with dsPICWorks from Microchip.
 *  dsPICWorks is a useful tool to generate signal. I develop a very "quick&durty" DOS program 
 *  in C to convert the dsPICWorks generated file as include file, using this struct declaration.
 *  
 *  To download dsPICWorks: 
 *  http://www.microchip.com/stellent/idcplg?IdcService=SS_GET_PAGE&nodeId=1406&dDocName=en023587
 *
 */
typedef struct _vawe_data
{
    int freq;                       // frequency value
    int srate;                      // sampling rate
    int samples;                    // number of sample
    const unsigned short *pdata;    // pointer to the array
} VAWE_DATA;

#endif
