#include "mbed.h"
#include "SDFileSystem.h"
#include "VLSIcodec.h"
#include "piano_A4.h"
#include "MI0283QTlib.h"

DigitalOut myled(LED2);
DigitalOut DBG_LED(LED1);
DigitalIn Volume( p30);
DigitalIn Pause( p25);
VS1053Codec codec( p11, p12, p13, p21, p22, p23, p24);

FILE *fp;
SDFileSystem sd(p5, p6, p7, p8, "sd");

GLCD lcd(  p11, p12, p13, p14, p17, p26);

void PlayPiano1( void);
void displayGA( unsigned char *gaval, unsigned char *gapeak, unsigned char bands);

unsigned char volval=0;
Timer t;
Serial pc(USBTX, USBRX);

unsigned char buff[64];

unsigned char gaval[14], gapeak[14];

int main() {

    int cnt;
    
    pc.baud( 115200);
    
    fp = fopen("/sd/mbed.txt", "w");
    if ( fp == NULL) {
        printf("Error opening file\n");
        DBG_LED=1;
        while(1);
    }
    fprintf( fp, "File mbed\n");
    fclose( fp);

    Volume.mode( PullUp);
    Pause.mode( PullUp);
    
   if ( (fp = fopen("/sd/sounds/0001.mp3", "r")) == NULL) {
    DBG_LED=1;
    printf("Errore apertura file MP3\r\n");
    while(1);
   }
    //
    lcd.backlightoff();
    lcd.lcd_init();
    lcd.lcd_clear( LCD_WHITE);
    lcd.backlighton();
   
    //
    codec.init();
    // codec.loadpatch();  
    codec.loadgapatch();  
    codec.setvolume( volval, volval);
    
    printf("Sine Test\r\n");
    codec.sinetest( 0x7d);
    wait( .5);
    codec.sinetest( 0x00);
    
    printf("Riproduzione del file MP3\n\r");

    codec.setbassboost( 15, 150);
    codec.settrebleboost( 7, 15000);
    codec.setvmeter();
    
    //
    unsigned short bands=codec.readgabands();
    printf("GA: Num of bands:%d\r\n", bands);
    
    t.start();
    while( 1) {
        cnt = fread(&buff[0], sizeof(buff[0]), sizeof(buff)/sizeof(buff[0]), fp);
        // loop di riproduzione.
        int iSize=0;
        while( iSize < cnt) {
            int count=32;
            codec.testdreq();
            while( count--) {
                codec.writedata( buff[ iSize++]);
                if ( iSize > cnt)
                    break;
            }
        }    
        // verifico l'esito della lettura. 
        if ( feof( fp)) {
            fclose( fp);
            DBG_LED=1;
            break;
        }
        //
        if ( !Volume) {
            volval++;
            codec.setvolume( volval, volval);
            printf("Set volume %d\n\r", volval);
        }
        //
        if ( !Pause) {
            // volume a zero
            codec.setvolume( 0xFE, 0xFE);
            // Aspetto finché il pulsante è premuto...
            while( !Pause);
            codec.setvolume( volval, volval);
        }
        //
        int tm=t.read_ms();
        //
        if ( tm>=100) {
            t.reset();
            //
            codec.readgavalue( &gaval[0], &gapeak[0]);
            displayGA( &gaval[0], &gapeak[0], bands);
#if 0            
            printf("SValue: ");
            for( int f=0; f<bands; f++) {
                printf("%2d, ",gaval[f]);
            }
#else
            printf("SPeak: ");
            for( int f=0; f<bands; f++) {
                printf("%2d, ",gapeak[f]);
            }
#endif            
            printf("\r\n");
        }
    }
    
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}

void PlayPiano1( void)
{
    // piano_note
    int cnt=sizeof(piano_A4)/sizeof(piano_A4[0]);
    printf("Riproduzione file MP3 piano_note [%d]\n\r", cnt);
    //
    int iSize=0;
    while( iSize < cnt) {
        int count=32;
        codec.testdreq();
        while( count--) {
            codec.writedata( piano_A4[ iSize++]);
            if ( iSize > cnt)
                break;
        }
    }
}

#define cBAR_MUL    2                       // moltiplicatore per aumentare il valore max della barra.
#define cBAR_MAX    31                      // massimo valore raggiunto dalla barra, come definito dal VS1053
#define cBAR_W      5                       // spessore barra
#define cBAR_H      (cBAR_MUL*cBAR_MAX)     // altezza della barra
#define cBAR_S      1                       // distanza tra le barre
#define cBAR_X      20                      // coordinata x iniziale
#define cBAR_Y      150                     // coordinata y iniziale  

const unsigned int bandscl[14]={ 0xff0000,0xff9933,0xffff66,0x99cc00,0x00ff00,0x33cc66,0x33ffcc,0x99ffff,0x0033cc,0x6666ff,
                                 0x9933cc,0xccccff,0x0066ff,0x333ff};
                                 
void displayGA( unsigned char *gaval, unsigned char *gapeak, unsigned char bands)
{
 
    lcd.lcd_clear( cBAR_X, cBAR_Y, (cBAR_W+cBAR_S)*bands, cBAR_H, LCD_WHITE);
    
    for ( int i=0; i<bands; i++) {
        //
        // lcd.lcd_clear( cBAR_X+(( cBAR_W+cBAR_S)*i), cBAR_Y, cBAR_W, cBAR_H, LCD_WHITE);
        // lcd.lcd_clear(unsigned int x0, unsigned int y0, unsigned int w, unsigned int h, unsigned int color)
        lcd.lcd_clear( cBAR_X+(( cBAR_W+cBAR_S)*i), cBAR_Y+(cBAR_H-(gaval[i]*cBAR_MUL) ), cBAR_W, gaval[i]*cBAR_MUL, bandscl[i]);
    }
}