#include "mbed.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

PwmOut rled(LED_RED);
PwmOut gled(LED_GREEN);
PwmOut bled(LED_BLUE);
Serial pc(USBTX, USBRX);

void motion( void);             // callback function for motion detection mode
void freefall( void);           // callback function for freefall detection mode
void orientation( void);        // callback function for orientation detection mode
void dataready( void);

unsigned int ff, md, od;
float sensor_data[3];
int16_t raw_data[3];

int main(void) {

    rled = 0.0;
    gled = 0.0;
    bled = 0.0;

    ff = md = 0;
    
    pc.baud( 230400);
    pc.printf("MMA8451 Accelerometer. [%X]\r\n", acc.getWhoAmI());

    // 
    pc.printf("FreeFall Detection\r\n");
    // Configure the accelerometer for the freefall detection and
    // set the callback function:
    acc.FreeFallDetection( &freefall);
    
    while( 1) {
        // please type in a key:
        if(pc.readable()) {
            switch (pc.getc()) {
                case 'f':
                // Configure the accelerometer for the freefall detection and
                // set the callback function:
                pc.printf("FreeFall Detection\r\n");
                acc.FreeFallDetection( &freefall);
                break;
                case 'm':
                // Configure the accelerometer for the motion detection and
                // set the callback function:
                pc.printf("Motion Detection\r\n");
                acc.MotionDetection( &motion);
                break;
                case 'o':
                // Configure the accelerometer for the orientation detection and
                // set the callback function:                
                pc.printf("Orientation Detection\r\n");
                acc.OrientationDetect( &orientation);
                break;
                case 'r':
                // Configure the accelerometer for the data ready and
                // set the callback function:                
                pc.printf("Data Ready\r\n");
                acc.DataReady( &dataready, cODR_1_56HZ);
                break;
                case 'w':
                // Read the accelorometer value in raw mode.
                pc.printf("Polling method and data raw\r\n");
                //
                while( 1) {
                    if ( pc.readable()) {
                        break;
                    }
                    // Check data availability
                    if ( acc.getAccRawAllAxis( &raw_data[0])) {
                        pc.printf("X: %X, Y: %X, Z: %X\r\n", raw_data[0], raw_data[1], raw_data[2]);
                        wait( 1.0);
                    }
                }
                break;

            }
        }
    }
}

// callback function for orientation detection mode
void orientation( void)
{ 
    unsigned char o;
    
    o = acc.GetOrientationState();
    
    bled = 1.0;
    
    od++;
    
    //
    if ( o & 0x01)
        pc.printf("Front ");
    else
        pc.printf("Back ");
    pc.printf("facing\r\n");
    
    //
    o = (o>>1) & 0x03;
    switch( o) {
        case 0:
        pc.printf("Portrait Up ");
        break;
        case 1:
        pc.printf("Portrait Down ");
        break;
        case 2:
        pc.printf("Landscape Right ");
        break;
        case 3:
        pc.printf("Landscape Left ");
        break;                
    }
    
    pc.printf( "\r\nod %d\t ornt: %X\r\n", od, o);
}

// callback function for motion detection mode
void motion( void)
{
    rled = 1.0;
    
    md++;
    pc.printf( "md %d\r\n", md);
}

// callback function for freefall detection mode
void freefall( void)
{
    gled = 1.0;
    
    ff++;
    pc.printf( "ff %d\r\n", ff);    
}

// callback function for data reading
void dataready( void)
{
    acc.getAccAllAxis( &sensor_data[0]);
    pc.printf("X: %f, Y: %f, Z: %f\r\n", sensor_data[0], sensor_data[1], sensor_data[2]);
}