/* mbed TouchScreen ADS7846 library. 

    Copyright (c) 2011 NXP 3803 
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

#ifndef __TOOUCH_H
#define __TOOUCH_H

#include "mbed.h"
#include "calibrate.h"

/* Define per la compilazione del codice di gestione del PENIRQ */
#define SW_PENIRQ
/* */
#define cTS_STARTBIT    0x80
#define cTS_MODE    0x00
#define cTS_SERDFR    0x00    /* SER/DFR =1 -> 0x04, */
#define cTS_PWRUP    0x03    /* Device is powered ON, PENIRQ OFF */
#define cTS_PWRDWN    0x00    /* Device is powered OFF, PENIRQ ON */
/* */
#define cTS_GETY    (cTS_STARTBIT|cTS_MODE|cTS_SERDFR|cTS_PWRUP|0x10)
#define cTS_GETX    (cTS_STARTBIT|cTS_MODE|cTS_SERDFR|cTS_PWRUP|0x50)
#define cTS_GETZ1    (cTS_STARTBIT|cTS_MODE|cTS_SERDFR|cTS_PWRUP|0x30)
#define cTS_GETZ2    (cTS_STARTBIT|cTS_MODE|cTS_SERDFR|cTS_PWRUP|0x40)
#define cTS_VBAT    (cTS_STARTBIT|cTS_MODE|cTS_SERDFR|cTS_PWRUP|0x20)
#define cTS_END        (cTS_STARTBIT|cTS_MODE|cTS_SERDFR|cTS_PWRDWN|0x50)
/* */
#define cTS_CMDSIZE    17
#define cTS_CROCINO    16
/* */
#define cTS_DEBOUNCE    2        /* 3ms di debounce x la pressione del touch */
/* FSM per la lettura del touch */
#define cTS_INIT        6
#define cTS_START       1
#define cTS_READ        2
#define cTS_RELEASING   3
#define cTS_RELEASED    4
#define cTS_STOP        5

#define TS_SPEED            1000000        /* 1Mbit */
#define BUS_MODE            3

/* We read the sample MAX_SAMPLES times*/
#define    MAX_SAMPLES        8


/* Data structure: x, y and pressure */
struct _TS_COORD {
    unsigned int        x;
    unsigned int        y;
    int                 z;
};

/* Collection of data about the touch... */
struct _TS_VALUE {
    _TS_COORD                   coord;              /* tap's coord. */
    volatile unsigned char      touched;            /* == 1 pen down. */
    unsigned char               calibration_done;   /* calibration done. */
};

/** TouchScreen ADS7846 Library
 *  From the DS:
 * The ADS7846 is a classic successive approximation register
 * (SAR) analog-to-digital converter (ADC). The architecture is
 * based on capacitive redistribution which inherently includes
 * a sample-and-hold function. The converter is fabricated on a
 * 0.6μm CMOS process.
 * 
 * The device features an internal 2.5V reference and an
 * external clock. Operation is maintained from a single supply
 * of 2.7V to 5.25V. The internal reference can be overdriven
 * with an external, low impedance source between 1V and
 * +VCC. The value of the reference voltage directly sets the
 * input range of the converter.
 * The analog input (X-, Y-, and Z-position coordinates, auxiliary
 * input, battery voltage, and chip temperature) to the
 * converter is provided via a multiplexer. A unique configuration
 * of low on-resistance touch panel driver switches allows
 * an unselected ADC input channel to provide power and its
 * accompanying pin to provide ground for an external device,
 * such as a touch screen
 * 
 * Example:
 * @code
 * // Please the main.c code as an elabora example.
 *
 * @endcode
 */

//
class TOUCHS {

public:

    /** Create the touch object
     *
     * @param pin mosi, pin miso, pin sclk, pin chip select and pin penirq
     */
    TOUCHS( PinName mosi, PinName miso, PinName sclk, PinName cs, PinName penirq);
    
    /** Initalize the touchscreen chip.
     *
     * @param none
     */
    void init( void);

    /** This function computes a matrix of data to be used for the conversion from touch to screen coord.
     * 
     * @param the coord of each crocino tapped by the user.
     */
    unsigned int setcalibration( _TS_COORD *ts);    
    
    /** I use a pool metod to read the touch. Each time I need to read the touch I loop until this function
     *  set a flag. It's also possible to configure this fuction as an handle of a Ticker class, checkin for 
     *  the flag inside the main loop.
     */
    void do_tap( void);
    
    /** Get the x coord of the crocino speicifyed by idx. There are three crocino defined inside the crocino.h header file
     *
     * @param idx One of the three crocino.
     * @return the x coord.
     */
    unsigned int getcrocino_x( unsigned char idx);
    
    /** Get the y coord of the crocino speicifyed by idx. There are three crocino defined inside the crocino.h header file
     *
     * @param idx One of the three crocino.
     * @return the x coord.
     */    
    unsigned int getcrocino_y( unsigned char idx);
    
    /** Get the pixel size of the crocino.
     *
     * @return the pixel size of the crocino.
     */    
    unsigned int crocino_size( void);
    
    /** Return the size of the TS_Matrix size.
     *
     * @return the size of the TS_Matrix
     */
    unsigned int gettsmatrixsize( void);
    
    /** Get the TS_Matrix 
     *
     * @param pmatrix Pointer to an area of RAM where the function store the content of the TS_Matrix
     */
    void gettsmatrix( unsigned char *pmatrix);
    
    /** Set the TS_Matrix with the content of the buffer.
     *
     * @param pmatrix Pointer to a buffer 
     */
    void settsmatrix( unsigned char *pmatrix);
    
    //
    _TS_VALUE       ts_val;
    
protected:
    /**
     */
    unsigned int pressure( void);
        
    /** This function convert from touch to screen coord.
     *  The value are stored inside the struct ts_val
     */
    unsigned int calibrate( void);

    /** Read the raw coordinate from the touchscreen 
     *
     * @param struct ts that will old the data.
     */
    void read( _TS_COORD *ts);
    
    _TS_VALUE       TS_value;
    _TS_COORD       TS_coord;
    SPI             _spi;
    DigitalOut      _cs;
    InterruptIn     _penirq;
};

#endif