/* mbed TouchScreen ADS7846 library. 

    Copyright (c) 2011 NXP 3803 
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

#include "mbed.h"
#include "string.h"
#include "Touchlib.h"
#include "calibrate.h"
#include "crocino.h"

/* */
unsigned char TSCmd[cTS_CMDSIZE] = { 
    cTS_GETY,   0x00,   cTS_GETY,   0x00,       /* y */
    cTS_GETZ1,  0x00,   cTS_GETZ1,  0x00,       /* z1 */
    cTS_GETZ2,  0x00,   cTS_GETZ2,  0x00,       /* z2 */
    cTS_GETX,   0x00,   cTS_END,    0x00, 0x00  /* x */
};

#define cTS_SAMPLE      8
#define MODE12          0

POINT crocino_coord[3] = {
    {80,120},
    {240,60},
    {240,180}
};

MATRIX  TS_Matrix;

unsigned char TSValue[cTS_CMDSIZE];
unsigned int tap_debounce;

DigitalOut TS_DBG_LED(LED4);
    
TOUCHS::TOUCHS(  PinName mosi, PinName miso, PinName sclk, PinName cs, PinName penirq) : _spi( mosi, miso, sclk), _cs( cs), _penirq( penirq) {
    // defaults params

}

unsigned int TOUCHS::setcalibration( _TS_COORD *ts)
{
    POINT screen[3];
    /* from struct TS_COORD to struct POINT. */
    screen[0].x=ts[0].x;
    screen[0].y=ts[0].y;
    screen[1].x=ts[1].x;
    screen[1].y=ts[1].y;
    screen[2].x=ts[2].x;
    screen[2].y=ts[2].y;        
    /* Now start the calibration process. */
    ts_val.calibration_done=!setCalibrationMatrix( &crocino_coord[0], &screen[0], &TS_Matrix);
    /* Return the result. */
    return( ts_val.calibration_done);
}

unsigned int TOUCHS::calibrate( void)
{
    POINT ts_tmp, coord;
    
    coord.x=ts_val.coord.x;
    coord.y=ts_val.coord.y;
    // see calibrate.c
    getDisplayPoint( &ts_tmp, &coord, &TS_Matrix);
    //
    ts_val.coord.x = ts_tmp.x;
    ts_val.coord.y = ts_tmp.y;
    
    return 0;
}

unsigned int TOUCHS::crocino_size( void)
{
    return( cTS_CROCINO);
}

unsigned int TOUCHS::getcrocino_x( unsigned char idx)
{
    if ( idx > 3)
        idx=3;
    
    return ( crocino_coord[idx].x);
}

unsigned int TOUCHS::getcrocino_y( unsigned char idx)
{
    if ( idx > 3)
        idx=3;
    
    return ( crocino_coord[idx].y);
}

unsigned int TOUCHS::gettsmatrixsize( void)
{
    return( sizeof( TS_Matrix));
}

void TOUCHS::gettsmatrix( unsigned char *pmatrix)
{

    *pmatrix++=((unsigned char*)&TS_Matrix.An)[0];
    *pmatrix++=((unsigned char*)&TS_Matrix.An)[1];
    *pmatrix++=((unsigned char*)&TS_Matrix.An)[2];
    *pmatrix++=((unsigned char*)&TS_Matrix.An)[3];
    *pmatrix++=((unsigned char*)&TS_Matrix.Bn)[0];
    *pmatrix++=((unsigned char*)&TS_Matrix.Bn)[1];
    *pmatrix++=((unsigned char*)&TS_Matrix.Bn)[2];
    *pmatrix++=((unsigned char*)&TS_Matrix.Bn)[3];
    *pmatrix++=((unsigned char*)&TS_Matrix.Cn)[0];
    *pmatrix++=((unsigned char*)&TS_Matrix.Cn)[1];
    *pmatrix++=((unsigned char*)&TS_Matrix.Cn)[2];
    *pmatrix++=((unsigned char*)&TS_Matrix.Cn)[3];
    *pmatrix++=((unsigned char*)&TS_Matrix.Dn)[0];
    *pmatrix++=((unsigned char*)&TS_Matrix.Dn)[1];
    *pmatrix++=((unsigned char*)&TS_Matrix.Dn)[2];
    *pmatrix++=((unsigned char*)&TS_Matrix.Dn)[3];
    *pmatrix++=((unsigned char*)&TS_Matrix.En)[0];
    *pmatrix++=((unsigned char*)&TS_Matrix.En)[1];
    *pmatrix++=((unsigned char*)&TS_Matrix.En)[2];
    *pmatrix++=((unsigned char*)&TS_Matrix.En)[3];
    *pmatrix++=((unsigned char*)&TS_Matrix.Fn)[0];
    *pmatrix++=((unsigned char*)&TS_Matrix.Fn)[1];
    *pmatrix++=((unsigned char*)&TS_Matrix.Fn)[2];
    *pmatrix++=((unsigned char*)&TS_Matrix.Fn)[3];
    *pmatrix++=((unsigned char*)&TS_Matrix.Divider)[0];
    *pmatrix++=((unsigned char*)&TS_Matrix.Divider)[1];
    *pmatrix++=((unsigned char*)&TS_Matrix.Divider)[2];
    *pmatrix++=((unsigned char*)&TS_Matrix.Divider)[3];

}

void TOUCHS::settsmatrix( unsigned char *pmatrix)
{

    ((unsigned char*)&TS_Matrix.An)[0]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.An)[1]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.An)[2]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.An)[3]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Bn)[0]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Bn)[1]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Bn)[2]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Bn)[3]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Cn)[0]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Cn)[1]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Cn)[2]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Cn)[3]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Dn)[0]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Dn)[1]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Dn)[2]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Dn)[3]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.En)[0]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.En)[1]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.En)[2]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.En)[3]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Fn)[0]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Fn)[1]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Fn)[2]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Fn)[3]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Divider)[0]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Divider)[1]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Divider)[2]=*pmatrix++;
    ((unsigned char*)&TS_Matrix.Divider)[3]=*pmatrix++;
    
    ts_val.calibration_done=1;
        
}

void TOUCHS::init( void)
{
    _spi.format( 8, BUS_MODE);
    _spi.frequency( TS_SPEED);
    
}


void TOUCHS::do_tap( void)
{
    unsigned int i, x, y;
    
    if ( TOUCHS::pressure() && ts_val.touched==0) {
        printf("press: %d\r\n", tap_debounce );
        tap_debounce++;
        if ( tap_debounce>= cTS_DEBOUNCE) {
            tap_debounce=0;
            ts_val.touched=1;
            for ( i=4, x=0,y=0; i!=0; i--) {
                TOUCHS::read( &ts_val.coord);
                x+=ts_val.coord.x;
                y+=ts_val.coord.y;
            }
            ts_val.coord.x=x>>2;
            ts_val.coord.y=y>>2;
            // If the calibration process was successful complited...
            if ( ts_val.calibration_done) {
                // ...run the convertion from touch to screen coord.
                TOUCHS::calibrate();       
            }         
        }
    }       
}

unsigned int TOUCHS::pressure( void)
{
    unsigned char pressure; 
    unsigned char iZ2, iZ1;

    _spi.frequency( TS_SPEED);
   
    _cs = 0;                            /* Seleziono il CS del TS */
    
    _spi.write( 0xB0);    
    iZ1 = _spi.write( 0x00);
    //
    _spi.write( 0xC0);
    iZ2 = 127-_spi.write( 0x00);
    _cs = 1;                            /* De-Seleziono il CS del TS */
    
    pressure=iZ1+iZ2;
   
    if ( pressure > 3) {
        // ts_val.touched=1;
        return( 1);
    } else {
        // ts_val.touched=0;
        return( 0);  
    }        
    
}

/* Read the value from the touch. Write the raw value inside the struct TS_COORD. */
void TOUCHS::read( _TS_COORD *ts)
{
    unsigned int i, idx;
    unsigned int iZ1, iZ2;
    
    _spi.frequency( TS_SPEED);
    
    idx=0;
    while( 1) {
        //
        i=0;
        _cs = 0;                            /* Assert the CS */
            
        while ( i<cTS_CMDSIZE) {
            TSValue[i] = _spi.write( TSCmd[i]);
            /* */
            i++;
        }
        
        _cs = 1;                            /* Deasser the CS */
    
        /* */
        ts->x = ((unsigned int)TSValue[15]<<5) | (TSValue[16]>>3);
        ts->y = ((unsigned int)TSValue[3]<<5) | (TSValue[4]>>3);
        iZ2   = ((unsigned int)TSValue[11]<<5) | (TSValue[12]>>3);
        iZ1   = ((unsigned int)TSValue[7]<<5) | (TSValue[8]>>3);
        ts->z =  (int)(330.0 * (((double)ts->x)/4096.0)*((((double)iZ2)/((double)iZ1))-1.0));
    
        /* Reduce the value to 10bit */
        ts->y = (ts->y >> MODE12);
        ts->x = (ts->x >> MODE12);
        
        idx++;
        if ( ts->z < 10000 || idx>10)
            break;
    }
}

