#include "mbed.h"
#include "Touchlib.h"
#include "MI0283QTlib.h"
#include "SDFileSystem.h"
//
#include "info.h"
//
#include "crocino.h"

unsigned char CheckRectangle (unsigned int X_up, unsigned int Y_up,unsigned int X_size, unsigned int Y_size, unsigned int X_point, unsigned int Y_point );
void test_touch( void) ;

DigitalOut DBG_LED(LED1);
DigitalOut myled(LED2);
DigitalOut TS_CS(p15);
DigitalIn MAKECAL( p30);

FILE *fp, *fpf;

TOUCHS ts(  p11, p12, p13, p15, p29);
GLCD lcd(  p11, p12, p13, p14, p17, p26);
SDFileSystem sd(p5, p6, p7, p8, "sd");
//
unsigned char imageLinebuffer[320*3];
unsigned char docalibration=0;

int main() {

    _TS_COORD ts_coord[3];
    TS_CS=1;
    
    // I use the pin30 to force a calibration.
    MAKECAL.mode( PullUp);

    // is there an sdcard?    
    fp = fopen("/sd/mbed.txt", "w");
    if ( fp == NULL) {
        printf("Error opening file\r\n");
        DBG_LED=1;
        while(1);
    }
    fprintf( fp, "File mbed\n");
    fclose( fp);
    
    // lcd init
    lcd.lcd_init();
    lcd.backlightoff();
    // some setup..
    lcd.lcd_setfontsmall();
    lcd.lcd_clear( LCD_WHITE);
    lcd.backlighton();

    // splash screen...
    fp = fopen("/sd/images/mi0283qt.RGB", "rb");
    if ( fp != NULL) {
        lcd.lcd_drawimage( "/sd/images/mi0283qt.RGB");
        fclose( fp);
        wait(3);
    }

    //
    lcd.lcd_clear( LCD_BLACK);
    // touch init...
    ts.init();
    
    // 1. we check if there is a saved file with the calibration data...
    fp = fopen("/sd/ts_mtx.bin", "rb");
    if ( fp == NULL) {
        // not found...
        printf("ts_mtx.bin is not present.\r\n");
        // next we must start the calibration process...
        docalibration=1;
    } else {
        printf("ts_mtx.bin exist\r\n");
        unsigned char *pmatrix;
        /* we allocate memory to hold the saved caibration data. */
        pmatrix=(unsigned char*)malloc( ts.gettsmatrixsize());
        if( pmatrix==NULL) {
            printf("Error allocating memory\r\n");
            DBG_LED=1;
            while(1);    
        }
        /* read the calibration data. */
        int mtxsize=fread( pmatrix, 1, ts.gettsmatrixsize(), fp);
        fclose( fp);
        printf("matrix_read: %d\r\n", mtxsize);
        if ( mtxsize != ts.gettsmatrixsize()) {
            printf("error reading the calibration data... force the calibration.\r\n");
            /* error reading the calibration data... force the calibration.*/
            docalibration=1;
            free( pmatrix);
        } else {
            /* set the calibration data. */
            ts.settsmatrix( pmatrix);
            docalibration=0;
            free( pmatrix);
        }
    }
    //
    while( docalibration || MAKECAL==0) {
        
        printf("Starting the calibration...\r\n");
        wait( 1);
        
        /* reset the calibration flag. */
        ts.ts_val.calibration_done=0;
        lcd.lcd_drawstr( "TouchScreen Calibration... [1/3]", 0, 0, lcd.lcd_RGB( 0, 255, 0));
        lcd.lcd_drawicon( &crocino[0], ts.getcrocino_x(0),ts.getcrocino_y(0), ts.crocino_size());
        
        ts.ts_val.touched=0;
        while( !ts.ts_val.touched) {
            ts.do_tap();
        }
        //
        lcd.lcd_clear( ts.getcrocino_x(0),ts.getcrocino_y(0), ts.crocino_size(), ts.crocino_size(), LCD_BLACK );
        //
        ts_coord[0].x=ts.ts_val.coord.x; ts_coord[0].y=ts.ts_val.coord.y; 
        //
        wait( 0.5);
        lcd.lcd_drawstr( "TouchScreen Calibration... [2/3]", 0, 0, lcd.lcd_RGB( 0, 255, 0));
        lcd.lcd_drawicon( &crocino[0], ts.getcrocino_x(1),ts.getcrocino_y(1), ts.crocino_size());
        
        ts.ts_val.touched=0;
        while( !ts.ts_val.touched) {
            ts.do_tap();
        }
        //
        lcd.lcd_clear( ts.getcrocino_x(1),ts.getcrocino_y(1), ts.crocino_size(), ts.crocino_size(), LCD_BLACK );
        //        
        ts_coord[1].x=ts.ts_val.coord.x; ts_coord[1].y=ts.ts_val.coord.y; 
        //
        wait( 0.5);
        lcd.lcd_drawstr( "TouchScreen Calibration... [3/3]", 0, 0, lcd.lcd_RGB( 0, 255, 0));
        lcd.lcd_drawicon( &crocino[0], ts.getcrocino_x(2),ts.getcrocino_y(2), ts.crocino_size());
        
        ts.ts_val.touched=0;
        while( !ts.ts_val.touched) {
            ts.do_tap();
        }
        //
        lcd.lcd_clear( ts.getcrocino_x(2),ts.getcrocino_y(2), ts.crocino_size(), ts.crocino_size(), LCD_BLACK );
        //        
        ts.ts_val.touched=0;
        ts_coord[2].x=ts.ts_val.coord.x; ts_coord[2].y=ts.ts_val.coord.y; 
        //
        lcd.lcd_clear( LCD_BLACK);
        if ( ts.setcalibration( &ts_coord[0])) {
            lcd.lcd_drawstr( "TouchScreen Calibration... Done!", 0, 0, lcd.lcd_RGB( 0, 255, 0));
            wait( 3);
            /* save the file with the calibration data. */ 
            fp = fopen("/sd/ts_mtx.bin", "wb");
            if ( fp == NULL) {
                printf("Error opening file\r\n");
                DBG_LED=1;
                while(1);
            }
            /* we allocate memory to get the calibration data to save. */
            unsigned char *pmatrix;
            pmatrix=(unsigned char*)malloc( ts.gettsmatrixsize());
            if( pmatrix==NULL) {
                printf("Error allocating memory\r\n");
                DBG_LED=1;
                while(1);    
            }
            /* get the calibration data. */
            ts.gettsmatrix( pmatrix);
            /* save the data to the file. */
            int mtxsize=fwrite( pmatrix, 1, ts.gettsmatrixsize(), fp);
            fflush( fp);
            fclose( fp);
            printf("matrix_size: %d\r\n", mtxsize);
            /* */
            if ( mtxsize != ts.gettsmatrixsize()) {
                printf("Error writing calibration data \r\n");
                docalibration=1;
                free( pmatrix);
            } else {
                printf("ts_mtx.bin saved\r\n");
                /* exit from the calibration loop.*/
                docalibration=0;
                free( pmatrix);
            }
        } else {
            lcd.lcd_drawstr( "TouchScreen Calibration... ERROR!", 0, 0, lcd.lcd_RGB( 0, 255, 0));
            wait( 3);
            lcd.lcd_clear( LCD_BLACK);
            docalibration=1;
        }            
    }

    char fnm[20];
    int x_img=160, y_img=120;
    unsigned char idx_pos=0;
    char fname[4][64];
    unsigned int idxf=20;
    //
    unsigned int changeImage=1;
    unsigned int linepos=0;
    unsigned int filepos=0;
    unsigned int size;
    unsigned int redraw_quad;
    
    while( 1) {
        // loop
        idx_pos=0;
        while( 1) {
            // open the image files stored as NNNN.rgb
            sprintf( fnm, "/sd/images/%04d.rgb\0", idxf);
            while( (fpf=fopen( (char *)fnm, "r")) == NULL) {
                DBG_LED=1;
                printf( "Errore su file: %s\r\n", (char *)fnm);
                if ( fpf)
                    fclose( fpf);
                //
                idxf++;
                if ( idxf > 1700)        // a huge images repository!
                    idxf=0;
                //
                sprintf( fnm, "/sd/images/%04d.rgb\0", idxf);
            }
            //
            strcpy( &fname[idx_pos][0], fnm);
            idxf++;
            printf("Image: %s, idx_pos: %d, fname: %s\r\n", fnm, idx_pos, &fname[idx_pos][0]);
            //
            linepos=0;
            while( feof( fpf)==0) {
                // calculate the position inside the file to read the image...
                filepos=( sizeof(imageLinebuffer)/sizeof(imageLinebuffer[0]) ) * linepos * SCALE_160x120;
                fseek( fpf, filepos, SEEK_SET );
                // read the entire line...
                size=fread( &imageLinebuffer[0], sizeof(imageLinebuffer[0]), sizeof(imageLinebuffer)/sizeof(imageLinebuffer[0]), fpf);
                // and draw it...
                lcd.lcd_drawimagebyline( &imageLinebuffer[0], linepos, x_img*(idx_pos&0x1), y_img*((idx_pos>>1)&0x1), SCALE_160x120);
                linepos++;
            }
            // close the file...
            fclose( fpf);
            printf("x_img= %d, y_img= %d\r\n", x_img*(idx_pos&0x1), y_img*((idx_pos>>1)&0x1));
            // change the image position inside the quad
            idx_pos++;
            idx_pos%=4;
            // check if the screen is full with 4 images...
            if ( idx_pos==0)
                break;
        }
        //
        // at this point there are 4 images draw on the screen.
        // just wait the user to press the TS.
        //
        idx_pos=0;
        redraw_quad=0;
        while( redraw_quad==0) {
            // just loop waiting for a tap...
            while( !ts.ts_val.touched) {
                ts.do_tap();
            }
            ts.ts_val.touched=0;
            // first check if the user tap on the bottom left 
            if ( CheckRectangle( 0, 180, 80, 60, ts.ts_val.coord.x, ts.ts_val.coord.y) )  {
                // tap on left. Change the image index to go back.
                idxf-=8;
                break;
            }
            // ...or bottom right.
            if ( CheckRectangle( 240, 180, 80, 60, ts.ts_val.coord.x, ts.ts_val.coord.y) )  {
                // tap on right. Nothing to change, the index image is pointing the next four images.
                break;
            }
            // ...or upper right.
            if ( CheckRectangle( 240, 0, 80, 60, ts.ts_val.coord.x, ts.ts_val.coord.y) )  {
                // tap on upper right. Lets movies...
           
                // more big movie (160x120 pixel)
                lcd.lcd_clear( LCD_WHITE);
                if ( lcd.lcd_drawmoviebuff( "/sd/movies2/unicolcd.bin", 160-80, 120-60) == 0) {
                    printf("Errore apertura file\r\n");
                    DBG_LED=1;
                }

                wait( 1);
                // small movie (80x60 pixel) at 15fs.
                if ( lcd.lcd_drawmovie( "/sd/movies1/unico.bin", 160-40, 120-30) == 0) {
                    printf("Errore apertura file\r\n");
                    DBG_LED=1;
                }

#if 0
                //
                // But now I can't continue! Please reset!  :-)
                // There is a bug in my code that, after the play of the big movie
                // the screen area remain like the area of the movie. The LCD does not receive more area command.
                // Sometimes it works sometimes not...
                //
                while( 1);
#endif                
            }            
            // ...or upper left.
            if ( CheckRectangle( 0, 0, 80, 60, ts.ts_val.coord.x, ts.ts_val.coord.y) )  {
                // tap on upper left. Display the TS test...
                test_touch();
                idxf-=4;
                break;
            }
            // at this point we check which image is tapped
            idx_pos=0;
            while( idx_pos < 4) {
                // we use the same index methodology to calculate the coordinate of the area tapped...
                if ( CheckRectangle( x_img*(idx_pos&0x1), y_img*((idx_pos>>1)&0x1), 160, 120, ts.ts_val.coord.x, ts.ts_val.coord.y) )  {
                    // an image is selected so draw it at full screen
                    lcd.lcd_drawimagebuff( &fname[idx_pos][0]);
                    // wait for a tap to exit.
                    while( !ts.ts_val.touched) {
                        ts.do_tap();
                    }
                    ts.ts_val.touched=0;
                    // let stop the waiting loop to redraw the quad screen.
                    redraw_quad=1;
                    // change the image index to redraw the same images.
                    idxf-=4;
                    // exit the loop
                    break;
                }
                //
                idx_pos++;
            }
            idx_pos=0;
        }
    }

}

void test_touch( void) 
{

    // test the TS capability...    
    // Please connect a serial cable to see the result...
    //
    lcd.lcd_clear( LCD_WHITE);   
    lcd.lcd_setbackgroundcolor( LCD_WHITE);
    // four icons on the left.
    lcd.lcd_drawicon( (unsigned char*)&info[0], 0, 24, 48);          // icona 1
    lcd.lcd_drawicon( (unsigned char*)&info[0], 0, 24+48, 48);       // icona 2
    lcd.lcd_drawicon( (unsigned char*)&info[0], 0, 24+48+48, 48);    // icona 3
    lcd.lcd_drawicon( (unsigned char*)&info[0], 0, 24+48+48+48, 48); // icona 4
    // two icons at the bottom.
    lcd.lcd_drawicon( (unsigned char*)&info[0], 136, 192, 48);       // icona 5
    lcd.lcd_drawicon( (unsigned char*)&info[0], 136+48, 192, 48);    // icona 6
    //
    lcd.lcd_drawstr("Tap here to exit", 220, 20, LCD_BLACK);
    // loop forever...
    while( 1)
    {
        //              
        printf("Starting the loop...\n\r");
        while( !ts.ts_val.touched) {
            ts.do_tap();
        }
        ts.ts_val.touched=0;
        //
        lcd.lcd_drawstr("Out!!!     ", 240, 10, LCD_BLACK);
        //
        if ( CheckRectangle( 0, 24, 48, 48, ts.ts_val.coord.x, ts.ts_val.coord.y) ) 
            lcd.lcd_drawstr("Icona 1    ", 240, 10, LCD_BLACK);
        if ( CheckRectangle( 0, 24+48, 48, 48, ts.ts_val.coord.x, ts.ts_val.coord.y) ) 
            lcd.lcd_drawstr("Icona 2    ", 240, 10, LCD_BLACK);
        if ( CheckRectangle( 0, 24+48+48, 48, 48, ts.ts_val.coord.x, ts.ts_val.coord.y) ) 
            lcd.lcd_drawstr("Icona 3    ", 240, 10, LCD_BLACK);
        if ( CheckRectangle( 0, 24+48+48+48, 48, 48, ts.ts_val.coord.x, ts.ts_val.coord.y) ) 
            lcd.lcd_drawstr("Icona 4    ", 240, 10, LCD_BLACK);
        if ( CheckRectangle( 136, 192, 48, 48, ts.ts_val.coord.x, ts.ts_val.coord.y) ) 
            lcd.lcd_drawstr("Icona 5    ", 240, 10, LCD_BLACK);
        if ( CheckRectangle( 136+48, 192, 48, 48, ts.ts_val.coord.x, ts.ts_val.coord.y) ) 
            lcd.lcd_drawstr("Icona 6    ", 240, 10, LCD_BLACK);

        // ...or upper right to exit.
        if ( CheckRectangle( 240, 0, 80, 60, ts.ts_val.coord.x, ts.ts_val.coord.y) ) 
            break;
                    
        printf("X:%5d\tY:%5d\tZ:%d\r\n", ts.ts_val.coord.x, ts.ts_val.coord.y, ts.ts_val.coord.z);
        wait_ms( 250);
    }

}

/*************************************************************************
 * Function Name: CheckRectangle
 * Parameters: Int32U X_up, Int32U Y_up - rectangle coordinate
 *             Int32U X_size, Int32U Y_size - rectangle size
 *             Int32U X_poin, Int32U Y_point - point coordinate
 *
 * Return: Boolean
 *    TRUE  - the point is inside  from the rectangle
 *    FALSE - the point is outside from the rectangle
 *
 * Description: Check whether the coordinate of point is inside from a rectangle
 *
 *************************************************************************/
unsigned char CheckRectangle (unsigned int X_up, unsigned int Y_up, unsigned int X_size, unsigned int Y_size, unsigned int X_point, unsigned int Y_point )
{
  if((X_up <= X_point) && (X_point <= X_up+X_size) &&
     (Y_up <= Y_point) && (Y_point <= Y_up+Y_size))
  {
    return ( 1);
  }
  return ( 0);
}
