#include "mbed.h"
#include "KL25Z_RTC.h"


DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

// Init the RTC module with an alarm value of 15 sec.
KL25Z_RTC rtc( 15);

// Callback user function
void alm ( void);
void sec ( void);

// Function to put in sleep or deepsleep the ARM Core.
#define SCB_SCR_SLEEPDEEP_MASK                   0x4u
void sleep( void);
void deepsleep (void);

unsigned int count;

int main() {
    
    pc.baud( 230400);
    pc.printf("RTC Management.\r\n");

    // rtc.RTC_Start( &sec, &alm);
    rtc.RTC_Start( NULL, &alm);
    pc.printf("Alarm configured [15sec], ");
    
    count=0;
    while(1) 
    {
        //
        pc.printf("enter sleep...\r\n");
        deepsleep();
        
        pc.printf("exit sleep: %d\r\n", ++count);
    }
}

void sec ( void)
{
    pc.printf("sec\r\n");
}

void alm ( void)
{
    pc.printf("alrm\r\n");
}    

void sleep( void)
{
    SCB->SCR &= ~SCB_SCR_SLEEPDEEP_MASK;
    __wfi();
}

void deepsleep (void)
{
  /* Set the SLEEPDEEP bit to enable deep sleep mode (STOP) */
  SCB->SCR |= SCB_SCR_SLEEPDEEP_MASK;

  __wfi();
}