/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#define NRF_LOG_BACKEND_SERIAL_USES_RTT 1
#define NRF_MODULE_ENABLED 1
#define NRF_LOG_BACKEND_RTT 1
#define NRF_LOG_USES_RTT 1
#define NRF_LOG_USES_COLORS 1
#define NRF_LOG_ENABLED 1
#define TWIS_CONFIG_LOG_ENABLED 1
#define TWI_CONFIG_LOG_ENABLED 1
#include "retarget_segger_rtt.h"
#include "mbed.h"
#include "stats_report.h"

#define ledRed_pin p12

DigitalOut led1(ledRed_pin);

#define SLEEP_TIME                  500 // (msec)
#define PRINT_AFTER_N_LOOPS         20

// main() runs in its own thread in the OS
int main()
{
    // Unneeded stuff
    //      SEGGER_RTT_Init();
    //      NRF_LOG_INIT();
    //      segger.write(buffer,2);

    SystemReport sys_state( SLEEP_TIME * PRINT_AFTER_N_LOOPS /* Loop delay time in ms */);

    int count = 0;
    while (true) {
        // Blink LED and wait 0.5 seconds
        led1 = !led1;
        wait_ms(SLEEP_TIME);
        // can use printf, but it gets stored in a buffer somewhere and isn't immediate
        printf("led");
        
        // USE SEGGER_RTT_WriteString
        // Very fast
        SEGGER_RTT_WriteString(0, "Hello World from SEGGER!\r\n");
        
        // NOT NEEDED, but could be usefull
        if ((0 == count) || (PRINT_AFTER_N_LOOPS == count)) {
            // Following the main thread wait, report on the current system status
            sys_state.report_state();
            count = 0;
        }
        ++count;
        
    }
}
